/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.api;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.jboss.resteasy.annotations.jaxrs.PathParam;
import org.jboss.resteasy.annotations.jaxrs.QueryParam;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.incoming.ModelIdCreator;
import org.kie.kogito.trusty.service.models.MatchedExecutionHeaders;
import org.kie.kogito.trusty.service.responses.ExecutionHeaderResponse;
import org.kie.kogito.trusty.service.responses.ExecutionsResponse;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="executions")
public class ExecutionsApiV1 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionsApiV1.class);
    @Inject
    TrustyService executionService;

    @GET
    @APIResponses(value={@APIResponse(description="Returns the execution headers.", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT, implementation=ExecutionsResponse.class))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Gets the execution headers", description="Gets the execution headers.")
    @Produces(value={"application/json"})
    public Response getExecutions(@Parameter(name="from", description="Start datetime for the lookup. Date in the format \"yyyy-MM-dd'T'HH:mm:ssZ\"", required=false, schema=@Schema(implementation=String.class)) @DefaultValue(value="yesterday") @QueryParam(value="from") String from, @Parameter(name="to", description="End datetime for the lookup. Date in the format \"yyyy-MM-dd'T'HH:mm:ssZ\"", required=false, schema=@Schema(implementation=String.class)) @DefaultValue(value="now") @QueryParam(value="to") String to, @Parameter(name="limit", description="Maximum number of results to return.", required=false, schema=@Schema(implementation=Integer.class)) @DefaultValue(value="100") @QueryParam(value="limit") int limit, @Parameter(name="offset", description="Offset for the pagination.", required=false, schema=@Schema(implementation=Integer.class)) @DefaultValue(value="0") @QueryParam(value="offset") int offset, @Parameter(name="search", description="Execution ID prefix to be matched", required=false, schema=@Schema(implementation=String.class)) @DefaultValue(value="") @QueryParam(value="search") String prefix) {
        OffsetDateTime toDate;
        OffsetDateTime fromDate;
        if (limit < 0 || offset < 0) {
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Pagination parameters can not have negative values.").build();
        }
        try {
            fromDate = this.parseParameterDate(from, true);
            toDate = this.parseParameterDate(to, false);
        }
        catch (DateTimeParseException e) {
            LOGGER.warn("Invalid date", (Throwable)e);
            return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)"Date format should be yyyy-MM-dd'T'HH:mm:ssZ").build();
        }
        MatchedExecutionHeaders result = this.executionService.getExecutionHeaders(fromDate, toDate, limit, offset, prefix);
        ArrayList<ExecutionHeaderResponse> headersResponses = new ArrayList<ExecutionHeaderResponse>();
        result.getExecutions().forEach(x -> headersResponses.add(ExecutionHeaderResponse.fromExecution(x)));
        return Response.ok((Object)new ExecutionsResponse(result.getAvailableResults(), limit, offset, headersResponses)).build();
    }

    private OffsetDateTime parseParameterDate(String date, boolean localDateAtStartOfDay) {
        if (date.equals("yesterday")) {
            return OffsetDateTime.now(ZoneOffset.UTC).minusDays(1L);
        }
        if (date.equals("now")) {
            return OffsetDateTime.now(ZoneOffset.UTC);
        }
        try {
            return ZonedDateTime.parse(date, DateTimeFormatter.ISO_OFFSET_DATE_TIME).toOffsetDateTime();
        }
        catch (DateTimeParseException e) {
            ZonedDateTime zonedDateTime = LocalDate.parse(date, DateTimeFormatter.ISO_DATE).atStartOfDay(ZoneId.systemDefault());
            return localDateAtStartOfDay ? zonedDateTime.toOffsetDateTime() : zonedDateTime.toOffsetDateTime().plusDays(1L).minusNanos(1L);
        }
    }

    @GET
    @Path(value="/{executionId}/model")
    @APIResponses(value={@APIResponse(description="Gets the model associated with an execution.", responseCode="200", content={@Content(mediaType="text/plain", schema=@Schema(type=SchemaType.STRING))}), @APIResponse(description="Bad Request", responseCode="400", content={@Content(mediaType="text/plain")})})
    @Operation(summary="Gets the model associated with an execution.")
    @Produces(value={"text/plain"})
    public Response getModel(@Parameter(name="executionId", description="The execution ID.", required=true, schema=@Schema(implementation=String.class)) @PathParam(value="executionId") String executionId) {
        return this.handleModelRequest(executionId);
    }

    private Response handleModelRequest(String executionId) {
        return this.retrieveModel(executionId).map(definition -> Response.ok((Object)definition).build()).orElseGet(() -> Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).build());
    }

    private Optional<String> retrieveModel(String executionId) {
        try {
            Optional<Decision> decision = this.retrieveDecision(executionId);
            return decision.map(d -> this.executionService.getModelById(ModelIdCreator.makeIdentifier(null, null, null, d.getExecutedModelName(), d.getExecutedModelNamespace())));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private Optional<Decision> retrieveDecision(String executionId) {
        try {
            return Optional.ofNullable(this.executionService.getDecisionById(executionId));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }
}

