/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;

public class MessagingUtils {
    public static TypedValue modelToTracingTypedValue(TypedVariable value) {
        if (value == null) {
            return null;
        }
        switch (value.getKind()) {
            case UNIT: {
                return new UnitValue(value.getTypeRef(), null, value.getValue());
            }
            case COLLECTION: {
                return new CollectionValue(value.getTypeRef(), MessagingUtils.modelToTracingTypedValueCollection(value.getComponents()));
            }
            case STRUCTURE: {
                return new StructureValue(value.getTypeRef(), MessagingUtils.modelToTracingTypedValueMap(value.getComponents()));
            }
        }
        throw new IllegalStateException("Can't convert org.kie.kogito.trusty.storage.api.model.TypedVariable of kind " + value.getKind() + " to TypedValue");
    }

    public static Collection<TypedValue> modelToTracingTypedValueCollection(Collection<TypedVariable> input) {
        if (input == null) {
            return null;
        }
        return input.stream().map(MessagingUtils::modelToTracingTypedValue).collect(Collectors.toList());
    }

    public static Map<String, TypedValue> modelToTracingTypedValueMap(Collection<TypedVariable> input) {
        if (input == null) {
            return null;
        }
        return input.stream().filter(m -> m.getName() != null).collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToTracingTypedValue(v)), HashMap::putAll);
    }

    private MessagingUtils() {
    }
}

