/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.cloudevents.jackson.JsonFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;

public class TypedVariableResponse {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule());
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="typeRef")
    private String typeRef;
    @JsonProperty(value="value")
    private JsonNode value;
    @JsonProperty(value="components")
    private List<JsonNode> components;

    private TypedVariableResponse() {
    }

    public TypedVariableResponse(String name, String typeRef, JsonNode value, List<JsonNode> components) {
        this.name = name;
        this.typeRef = typeRef;
        this.value = value;
        this.components = components;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeRef() {
        return this.typeRef;
    }

    public JsonNode getValue() {
        return this.value;
    }

    public List<JsonNode> getComponents() {
        return this.components;
    }

    public static TypedVariableResponse from(DecisionInput input) {
        return input != null ? TypedVariableResponse.from(input.getValue()) : null;
    }

    public static TypedVariableResponse from(TypedVariable value) {
        if (value == null) {
            return null;
        }
        switch (value.getKind()) {
            case COLLECTION: {
                return TypedVariableResponse.fromCollection(value);
            }
            case STRUCTURE: {
                return TypedVariableResponse.fromStructure(value);
            }
            case UNIT: {
                return TypedVariableResponse.fromUnit(value);
            }
        }
        throw new IllegalStateException(String.format("TypedVariable of kind %s can't be converted to TypedVariableResponse", value.getKind()));
    }

    private static TypedVariableResponse fromCollection(TypedVariable value) {
        boolean isCollectionOfStructures = value.getComponents() != null && value.getComponents().stream().anyMatch(t -> t.getKind() == TypedValue.Kind.STRUCTURE);
        JsonNode responseValue = isCollectionOfStructures || value.getComponents() == null ? null : (JsonNode)value.getComponents().stream().map(TypedVariableResponse::fromUnit).map(TypedVariableResponse::getValue).collect(() -> ((ObjectMapper)MAPPER).createArrayNode(), ArrayNode::add, ArrayNode::addAll);
        List responseComponents = !isCollectionOfStructures || value.getComponents() == null ? null : value.getComponents().stream().map(TypedVariableResponse::fromStructure).map(r -> r.getComponents().stream().collect(() -> ((ObjectMapper)MAPPER).createArrayNode(), ArrayNode::add, ArrayNode::addAll)).collect(Collectors.toList());
        return new TypedVariableResponse(value.getName(), value.getTypeRef(), responseValue, responseComponents);
    }

    private static TypedVariableResponse fromStructure(TypedVariable value) {
        List components = value.getComponents() == null ? null : value.getComponents().stream().map(TypedVariableResponse::from).map(arg_0 -> ((ObjectMapper)MAPPER).valueToTree(arg_0)).collect(Collectors.toList());
        return new TypedVariableResponse(value.getName(), value.getTypeRef(), null, components);
    }

    private static TypedVariableResponse fromUnit(TypedVariable value) {
        return new TypedVariableResponse(value.getName(), value.getTypeRef(), value.getValue(), null);
    }
}

