/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.extensions;

import io.cloudevents.CloudEventExtensions;
import io.cloudevents.Extension;
import io.cloudevents.core.extensions.impl.ExtensionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class DistributedTracingExtension
implements Extension {
    public static final String TRACEPARENT = "traceparent";
    public static final String TRACESTATE = "tracestate";
    private static final Set<String> KEY_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("traceparent", "tracestate")));
    private String traceparent;
    private String tracestate;

    public String getTraceparent() {
        return this.traceparent;
    }

    public void setTraceparent(String traceparent) {
        this.traceparent = traceparent;
    }

    public String getTracestate() {
        return this.tracestate;
    }

    public void setTracestate(String tracestate) {
        this.tracestate = tracestate;
    }

    @Override
    public void readFrom(CloudEventExtensions extensions) {
        Object ts;
        Object tp = extensions.getExtension(TRACEPARENT);
        if (tp != null) {
            this.traceparent = tp.toString();
        }
        if ((ts = extensions.getExtension(TRACESTATE)) != null) {
            this.tracestate = ts.toString();
        }
    }

    @Override
    public Object getValue(String key) {
        switch (key) {
            case "traceparent": {
                return this.traceparent;
            }
            case "tracestate": {
                return this.tracestate;
            }
        }
        throw ExtensionUtils.generateInvalidKeyException(this.getClass().getSimpleName(), key);
    }

    @Override
    public Set<String> getKeys() {
        return KEY_SET;
    }

    public String toString() {
        return "DistributedTracingExtension{traceparent='" + this.traceparent + '\'' + ", tracestate='" + this.tracestate + '\'' + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.traceparent == null ? 0 : this.traceparent.hashCode());
        result = 31 * result + (this.tracestate == null ? 0 : this.tracestate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistributedTracingExtension other = (DistributedTracingExtension)obj;
        if (this.traceparent == null ? other.traceparent != null : !this.traceparent.equals(other.traceparent)) {
            return false;
        }
        return !(this.tracestate == null ? other.tracestate != null : !this.tracestate.equals(other.tracestate));
    }
}

