/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v03;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import io.cloudevents.core.impl.CloudEventUtils;
import io.cloudevents.core.v03.CloudEventV03;
import io.cloudevents.core.v03.V1ToV03AttributesConverter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.types.Time;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;

public final class CloudEventBuilder
extends BaseCloudEventBuilder<CloudEventBuilder, CloudEventV03> {
    private String id;
    private URI source;
    private String type;
    private OffsetDateTime time;
    private URI schemaurl;
    private String datacontenttype;
    private String subject;

    public CloudEventBuilder() {
    }

    public CloudEventBuilder(CloudEvent event) {
        super(event);
    }

    @Override
    protected void setAttributes(CloudEvent event) {
        if (event.getSpecVersion() == SpecVersion.V03) {
            CloudEventUtils.toVisitable(event).readAttributes(this);
        } else {
            CloudEventUtils.toVisitable(event).readAttributes(new V1ToV03AttributesConverter(this));
        }
    }

    @Override
    public CloudEventBuilder withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public CloudEventBuilder withSource(URI source) {
        this.source = source;
        return this;
    }

    @Override
    public CloudEventBuilder withType(String type) {
        this.type = type;
        return this;
    }

    @Override
    public CloudEventBuilder withTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Override
    public CloudEventBuilder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public CloudEventBuilder withDataContentType(String dataContentType) {
        this.datacontenttype = dataContentType;
        return this;
    }

    public CloudEventBuilder withSchemaUrl(URI schemaUrl) {
        this.schemaurl = schemaUrl;
        return this;
    }

    @Override
    public CloudEventBuilder withDataSchema(URI dataSchema) {
        this.schemaurl = dataSchema;
        return this;
    }

    @Override
    public CloudEventV03 build() {
        if (this.id == null) {
            throw CloudEventBuilder.createMissingAttributeException("id");
        }
        if (this.source == null) {
            throw CloudEventBuilder.createMissingAttributeException("source");
        }
        if (this.type == null) {
            throw CloudEventBuilder.createMissingAttributeException("type");
        }
        return new CloudEventV03(this.id, this.source, this.type, this.time, this.schemaurl, this.datacontenttype, this.subject, this.data, this.extensions);
    }

    @Override
    public CloudEventBuilder newBuilder() {
        CloudEventBuilder newBuilder = new CloudEventBuilder();
        newBuilder.id = this.id;
        newBuilder.source = this.source;
        newBuilder.type = this.type;
        newBuilder.time = this.time;
        newBuilder.schemaurl = this.schemaurl;
        newBuilder.datacontenttype = this.datacontenttype;
        newBuilder.subject = this.subject;
        newBuilder.data = this.data;
        newBuilder.extensions.putAll(this.extensions);
        return newBuilder;
    }

    @Override
    public CloudEventBuilder withAttribute(String name, String value) throws CloudEventRWException {
        switch (name) {
            case "id": {
                this.withId(value);
                return this;
            }
            case "source": {
                try {
                    this.withSource(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue("source", value, e);
                }
                return this;
            }
            case "type": {
                this.withType(value);
                return this;
            }
            case "datacontenttype": {
                this.withDataContentType(value);
                return this;
            }
            case "datacontentencoding": {
                return this;
            }
            case "schemaurl": {
                try {
                    this.withSchemaUrl(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue("schemaurl", value, e);
                }
                return this;
            }
            case "subject": {
                this.withSubject(value);
                return this;
            }
            case "time": {
                try {
                    this.withTime(Time.parseTime(value));
                }
                catch (DateTimeParseException e) {
                    throw CloudEventRWException.newInvalidAttributeValue("time", value, e);
                }
                return this;
            }
        }
        throw CloudEventRWException.newInvalidAttributeName(name);
    }

    @Override
    public CloudEventBuilder withAttribute(String name, URI value) throws CloudEventRWException {
        switch (name) {
            case "source": {
                this.withSource(value);
                return this;
            }
            case "schemaurl": {
                this.withDataSchema(value);
                return this;
            }
        }
        throw CloudEventRWException.newInvalidAttributeType(name, URI.class);
    }

    @Override
    public CloudEventBuilder withAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
        if ("time".equals(name)) {
            this.withTime(value);
            return this;
        }
        throw CloudEventRWException.newInvalidAttributeType(name, OffsetDateTime.class);
    }
}

