/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.arc.Arc;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Merge;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.spi.Bean;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;

public class QuarkusMediatorConfiguration
implements MediatorConfiguration {
    private String beanId;
    private String methodName;
    private Class<?> returnType;
    private Class<?>[] parameterTypes;
    private Shape shape;
    private List<String> incomings = new ArrayList<String>();
    private String outgoing;
    private Acknowledgment.Strategy acknowledgment;
    private Integer broadcastValue;
    private MediatorConfiguration.Production production = MediatorConfiguration.Production.NONE;
    private MediatorConfiguration.Consumption consumption = MediatorConfiguration.Consumption.NONE;
    private boolean useBuilderTypes = false;
    private Merge.Mode merge;
    private Class<? extends Invoker> invokerClass;
    private boolean blocking;
    private boolean blockingExecutionOrdered;
    private String workerPoolName;
    private Type ingestedPayload;

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    @Override
    public Bean<?> getBean() {
        return Arc.container().bean(this.beanId);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    @Override
    public Shape shape() {
        return this.shape;
    }

    @Override
    public List<String> getIncoming() {
        return this.incomings;
    }

    public void setIncomings(List<String> incomings) {
        this.incomings = incomings;
    }

    @Override
    public String getOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(String outgoing) {
        this.outgoing = outgoing;
    }

    @Override
    public Acknowledgment.Strategy getAcknowledgment() {
        return this.acknowledgment;
    }

    public void setAcknowledgment(Acknowledgment.Strategy acknowledgment) {
        this.acknowledgment = acknowledgment;
    }

    public Integer getBroadcastValue() {
        return this.broadcastValue;
    }

    public void setBroadcastValue(Integer broadcastValue) {
        this.broadcastValue = broadcastValue;
    }

    @Override
    public boolean getBroadcast() {
        return this.broadcastValue != null;
    }

    public MediatorConfiguration.Production getProduction() {
        return this.production;
    }

    public void setProduction(MediatorConfiguration.Production production) {
        this.production = production;
    }

    @Override
    public MediatorConfiguration.Production production() {
        return this.production;
    }

    public MediatorConfiguration.Consumption getConsumption() {
        return this.consumption;
    }

    public void setConsumption(MediatorConfiguration.Consumption consumption) {
        this.consumption = consumption;
    }

    @Override
    public MediatorConfiguration.Consumption consumption() {
        return this.consumption;
    }

    public boolean isUseBuilderTypes() {
        return this.useBuilderTypes;
    }

    public void setUseBuilderTypes(boolean useBuilderTypes) {
        this.useBuilderTypes = useBuilderTypes;
    }

    @Override
    public boolean usesBuilderTypes() {
        return this.useBuilderTypes;
    }

    @Override
    public Merge.Mode getMerge() {
        return this.merge;
    }

    public void setMerge(Merge.Mode merge) {
        this.merge = merge;
    }

    @Override
    public Class<? extends Invoker> getInvokerClass() {
        return this.invokerClass;
    }

    @Override
    public Type getIngestedPayloadType() {
        return this.ingestedPayload;
    }

    public void setIngestedPayloadType(Type ingestedPayload) {
        this.ingestedPayload = ingestedPayload;
    }

    public void setInvokerClass(Class<? extends Invoker> invokerClass) {
        this.invokerClass = invokerClass;
    }

    @Override
    public String methodAsString() {
        return this.getBean().getBeanClass().getName() + "#" + this.getMethodName();
    }

    @Override
    public Method getMethod() {
        throw new UnsupportedOperationException("getMethod is not meant to be called on " + this.getClass().getName());
    }

    @Override
    public int getNumberOfSubscriberBeforeConnecting() {
        if (!this.getBroadcast()) {
            return -1;
        }
        return this.broadcastValue;
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public String getWorkerPoolName() {
        return this.workerPoolName;
    }

    @Override
    public boolean isBlockingExecutionOrdered() {
        return this.blockingExecutionOrdered;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public void setBlockingExecutionOrdered(boolean blockingExecutionOrdered) {
        this.blockingExecutionOrdered = blockingExecutionOrdered;
    }

    public void setWorkerPoolName(String workerPoolName) {
        this.workerPoolName = workerPoolName;
    }
}

