/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.schema;

import io.smallrye.openapi.api.constants.JDKConstants;
import io.smallrye.openapi.api.constants.MutinyConstants;
import io.smallrye.openapi.api.models.media.DiscriminatorImpl;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsReader;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.OpenApiDataObjectScanner;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScanner;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class SchemaFactory {
    private SchemaFactory() {
    }

    public static Schema readSchema(IndexView index, ClassLoader cl, AnnotationValue value) {
        if (value == null) {
            return null;
        }
        AnnotationInstance schemaAnnotation = value.asNested();
        if (schemaAnnotation == null) {
            return null;
        }
        IoLogging.log.singleAnnotation("@Schema");
        if (Boolean.TRUE.equals(JandexUtil.value(schemaAnnotation, "hidden"))) {
            return null;
        }
        return SchemaFactory.readSchema(index, cl, (Schema)new SchemaImpl(), schemaAnnotation, Collections.emptyMap());
    }

    public static Schema readSchema(IndexView index, ClassLoader cl, Schema schema, AnnotationInstance annotation, ClassInfo clazz) {
        return SchemaFactory.readSchema(index, cl, schema, annotation, clazz, Collections.emptyMap());
    }

    static Schema readSchema(IndexView index, ClassLoader cl, Schema schema, AnnotationInstance annotation, ClassInfo clazz, Map<String, Object> defaults) {
        if (annotation == null) {
            return schema;
        }
        Boolean isHidden = (Boolean)SchemaFactory.readAttr(annotation, "hidden", defaults);
        if (Boolean.TRUE.equals(isHidden)) {
            return schema;
        }
        schema = SchemaFactory.readSchema(index, cl, schema, annotation, defaults);
        ClassType clazzType = (ClassType)Type.create(clazz.name(), Type.Kind.CLASS);
        SchemaFactory.schemaRegistration(index, clazzType, schema);
        return schema;
    }

    public static Schema readSchema(IndexView index, ClassLoader cl, Schema schema, AnnotationInstance annotation, Map<String, Object> defaults) {
        if (annotation == null) {
            return schema;
        }
        Boolean isHidden = (Boolean)SchemaFactory.readAttr(annotation, "hidden", defaults);
        if (Boolean.TRUE.equals(isHidden)) {
            return schema;
        }
        schema.setNot(SchemaFactory.readAttr(annotation, "not", type -> SchemaFactory.readClassSchema(index, cl, type, true), defaults));
        schema.setOneOf(SchemaFactory.readAttr(annotation, "oneOf", type -> SchemaFactory.readClassSchemas(index, cl, type), defaults));
        schema.setAnyOf(SchemaFactory.readAttr(annotation, "anyOf", type -> SchemaFactory.readClassSchemas(index, cl, type), defaults));
        schema.setAllOf(SchemaFactory.readAttr(annotation, "allOf", type -> SchemaFactory.readClassSchemas(index, cl, type), defaults));
        schema.setTitle((String)SchemaFactory.readAttr(annotation, "title", defaults));
        schema.setMultipleOf(SchemaFactory.readAttr(annotation, "multipleOf", BigDecimal::valueOf, defaults));
        schema.setMaximum(SchemaFactory.readAttr(annotation, "maximum", BigDecimal::new, defaults));
        schema.setMinimum(SchemaFactory.readAttr(annotation, "minimum", BigDecimal::new, defaults));
        schema.setExclusiveMaximum((Boolean)SchemaFactory.readAttr(annotation, "exclusiveMaximum", defaults));
        schema.setExclusiveMinimum((Boolean)SchemaFactory.readAttr(annotation, "exclusiveMinimum", defaults));
        schema.setMaxLength((Integer)SchemaFactory.readAttr(annotation, "maxLength", defaults));
        schema.setMinLength((Integer)SchemaFactory.readAttr(annotation, "minLength", defaults));
        schema.setPattern((String)SchemaFactory.readAttr(annotation, "pattern", defaults));
        schema.setMaxProperties((Integer)SchemaFactory.readAttr(annotation, "maxProperties", defaults));
        schema.setMinProperties((Integer)SchemaFactory.readAttr(annotation, "minProperties", defaults));
        schema.setRequired((List)SchemaFactory.readAttr(annotation, "requiredProperties", defaults));
        schema.setDescription((String)SchemaFactory.readAttr(annotation, "description", defaults));
        schema.setFormat((String)SchemaFactory.readAttr(annotation, "format", defaults));
        schema.setRef((String)SchemaFactory.readAttr(annotation, "ref", defaults));
        schema.setNullable((Boolean)SchemaFactory.readAttr(annotation, "nullable", defaults));
        schema.setReadOnly((Boolean)SchemaFactory.readAttr(annotation, "readOnly", defaults));
        schema.setWriteOnly((Boolean)SchemaFactory.readAttr(annotation, "writeOnly", defaults));
        AnnotationInstance annotationInstance = (AnnotationInstance)JandexUtil.value(annotation, "externalDocs");
        schema.setExternalDocs(ExternalDocsReader.readExternalDocs(annotationInstance));
        schema.setDeprecated((Boolean)SchemaFactory.readAttr(annotation, "deprecated", defaults));
        Schema.SchemaType schemaType = SchemaFactory.readAttr(annotation, "type", value -> JandexUtil.enumValue(value, Schema.SchemaType.class), defaults);
        schema.setType(schemaType);
        schema.setExample(SchemaFactory.parseSchemaAttr(annotation, "example", defaults, schemaType));
        schema.setDefaultValue(SchemaFactory.readAttr(annotation, "defaultValue", defaults));
        schema.setDiscriminator(SchemaFactory.readDiscriminator(index, cl, (String)JandexUtil.value(annotation, "discriminatorProperty"), (AnnotationInstance[])JandexUtil.value(annotation, "discriminatorMapping")));
        schema.setMaxItems((Integer)SchemaFactory.readAttr(annotation, "maxItems", defaults));
        schema.setMinItems((Integer)SchemaFactory.readAttr(annotation, "minItems", defaults));
        schema.setUniqueItems((Boolean)SchemaFactory.readAttr(annotation, "uniqueItems", defaults));
        List enumeration = (List)SchemaFactory.readAttr(annotation, "enumeration", defaults);
        if (enumeration != null && !enumeration.isEmpty()) {
            schema.setEnumeration(enumeration);
        }
        boolean namedComponent = SchemaImpl.isNamed(schema);
        if (JandexUtil.isSimpleClassSchema(annotation)) {
            Schema implSchema = SchemaFactory.readClassSchema(index, cl, (Type)JandexUtil.value(annotation, "implementation"), !namedComponent);
            schema = MergeUtil.mergeObjects(implSchema, schema);
        } else if (JandexUtil.isSimpleArraySchema(annotation)) {
            Schema implSchema = SchemaFactory.readClassSchema(index, cl, (Type)JandexUtil.value(annotation, "implementation"), !namedComponent);
            schema.setItems(implSchema);
        } else {
            Schema implSchema = SchemaFactory.readClassSchema(index, cl, (Type)JandexUtil.value(annotation, "implementation"), false);
            if (schema.getType() == Schema.SchemaType.ARRAY && implSchema != null) {
                schema.setItems(implSchema);
            } else if (implSchema != null) {
                schema = MergeUtil.mergeObjects(implSchema, schema);
            }
        }
        return schema;
    }

    static <T> T readAttr(AnnotationInstance annotation, String propertyName, Map<String, Object> defaults) {
        Object value = JandexUtil.value(annotation, propertyName);
        if (value == null) {
            value = defaults.get(propertyName);
        } else if (value.getClass().isArray()) {
            value = Arrays.stream((Object[])value).collect(Collectors.toList());
        }
        return value;
    }

    static Object parseSchemaAttr(AnnotationInstance annotation, String propertyName, Map<String, Object> defaults, Schema.SchemaType schemaType) {
        return SchemaFactory.readAttr(annotation, propertyName, value -> {
            if (!(value instanceof String)) {
                return value;
            }
            String stringValue = (String)value;
            if (schemaType != Schema.SchemaType.STRING) {
                return JsonUtil.parseValue(stringValue);
            }
            return stringValue;
        }, defaults);
    }

    static <R, T> T readAttr(AnnotationInstance annotation, String propertyName, Function<R, T> converter, Map<String, Object> defaults) {
        Object rawValue = JandexUtil.value(annotation, propertyName);
        Object value = rawValue == null ? defaults.get(propertyName) : converter.apply(rawValue);
        return (T)value;
    }

    static Schema readClassSchema(IndexView index, ClassLoader cl, Type type, boolean schemaReferenceSupported) {
        Schema schema;
        if (type == null) {
            return null;
        }
        if (type.kind() == Type.Kind.ARRAY) {
            schema = new SchemaImpl().type(Schema.SchemaType.ARRAY);
            ArrayType array = type.asArrayType();
            int dimensions = array.dimensions();
            Type componentType = array.component();
            if (dimensions > 1) {
                schema.items(SchemaFactory.readClassSchema(index, cl, ArrayType.create(componentType, dimensions - 1), schemaReferenceSupported));
            } else {
                schema.items(SchemaFactory.readClassSchema(index, cl, componentType, schemaReferenceSupported));
            }
        } else {
            schema = type.kind() == Type.Kind.PRIMITIVE ? OpenApiDataObjectScanner.process(type.asPrimitiveType()) : SchemaFactory.introspectClassToSchema(index, cl, type.asClassType(), schemaReferenceSupported);
        }
        return schema;
    }

    public static Schema typeToSchema(IndexView index, ClassLoader cl, Type type, List<AnnotationScannerExtension> extensions) {
        Schema schema = null;
        AnnotationScanner annotationScanner = CurrentScannerInfo.getCurrentAnnotationScanner();
        if (TypeUtil.isOptional(type)) {
            return SchemaFactory.typeToSchema(index, cl, TypeUtil.getOptionalType(type), extensions);
        }
        if (annotationScanner.isWrapperType(type)) {
            return SchemaFactory.typeToSchema(index, cl, annotationScanner.unwrapType(type), extensions);
        }
        if (type.kind() == Type.Kind.ARRAY) {
            schema = new SchemaImpl().type(Schema.SchemaType.ARRAY);
            ArrayType array = type.asArrayType();
            int dimensions = array.dimensions();
            Type componentType = array.component();
            if (dimensions > 1) {
                schema.items(SchemaFactory.typeToSchema(index, cl, ArrayType.create(componentType, dimensions - 1), extensions));
            } else {
                schema.items(SchemaFactory.typeToSchema(index, cl, componentType, extensions));
            }
        } else {
            schema = type.kind() == Type.Kind.CLASS ? SchemaFactory.introspectClassToSchema(index, cl, type.asClassType(), true) : (type.kind() == Type.Kind.PRIMITIVE ? OpenApiDataObjectScanner.process(type.asPrimitiveType()) : SchemaFactory.otherTypeToSchema(index, cl, type, extensions));
        }
        return schema;
    }

    public static Schema enumToSchema(IndexView index, ClassLoader cl, Type enumType) {
        IoLogging.log.enumProcessing(enumType);
        int ENUM = 16384;
        ClassInfo enumKlazz = index.getClassByName(TypeUtil.getName(enumType));
        AnnotationInstance schemaAnnotation = enumKlazz.classAnnotation(SchemaConstant.DOTNAME_SCHEMA);
        Schema enumSchema = new SchemaImpl();
        List<Object> enumeration = enumKlazz.fields().stream().filter(field -> (field.flags() & 0x4000) != 0).map(FieldInfo::name).sorted().collect(Collectors.toList());
        if (schemaAnnotation != null) {
            HashMap<String, Object> defaults = new HashMap<String, Object>(2);
            defaults.put("type", (Object)Schema.SchemaType.STRING);
            defaults.put("enumeration", enumeration);
            enumSchema = SchemaFactory.readSchema(index, cl, enumSchema, schemaAnnotation, enumKlazz, defaults);
        } else {
            enumSchema.setType(Schema.SchemaType.STRING);
            enumSchema.setEnumeration(enumeration);
        }
        return enumSchema;
    }

    private static Schema introspectClassToSchema(IndexView index, ClassLoader cl, ClassType ctype, boolean schemaReferenceSupported) {
        AnnotationScanner annotationScanner = CurrentScannerInfo.getCurrentAnnotationScanner();
        if (annotationScanner.isScannerInternalResponse(ctype)) {
            return null;
        }
        SchemaRegistry schemaRegistry = SchemaRegistry.currentInstance();
        if (schemaReferenceSupported && schemaRegistry.has(ctype)) {
            return schemaRegistry.lookupRef(ctype);
        }
        Schema schema = OpenApiDataObjectScanner.process(index, cl, ctype);
        if (schemaReferenceSupported) {
            return SchemaFactory.schemaRegistration(index, ctype, schema);
        }
        return schema;
    }

    static Schema schemaRegistration(IndexView index, Type type, Schema schema) {
        SchemaRegistry schemaRegistry = SchemaRegistry.currentInstance();
        if (SchemaFactory.allowRegistration(index, schemaRegistry, type, schema)) {
            schema = schemaRegistry.register(type, schema);
        }
        return schema;
    }

    static boolean allowRegistration(IndexView index, SchemaRegistry registry, Type type, Schema schema) {
        if (schema == null || registry == null || !registry.isTypeRegistrationSupported(type, schema)) {
            return false;
        }
        return !registry.has(type) || !registry.lookupRef(type).equals(schema);
    }

    private static List<Schema> readClassSchemas(IndexView index, ClassLoader cl, Type[] types) {
        IoLogging.log.annotationsList("schema Class");
        return Arrays.stream(types).map(type -> SchemaFactory.readClassSchema(index, cl, type, true)).collect(Collectors.toList());
    }

    private static Schema otherTypeToSchema(IndexView index, ClassLoader cl, Type type, List<AnnotationScannerExtension> extensions) {
        if (TypeUtil.isA(index, cl, type, MutinyConstants.MULTI_TYPE)) {
            Schema schema = new SchemaImpl().type(Schema.SchemaType.ARRAY);
            Type componentType = type.asParameterizedType().arguments().get(0);
            schema.items(SchemaFactory.typeToSchema(index, cl, componentType, extensions));
            return schema;
        }
        Type asyncType = SchemaFactory.resolveAsyncType(index, cl, type, extensions);
        return SchemaFactory.schemaRegistration(index, asyncType, OpenApiDataObjectScanner.process(index, cl, asyncType));
    }

    static Type resolveAsyncType(IndexView index, ClassLoader cl, Type type, List<AnnotationScannerExtension> extensions) {
        ParameterizedType pType;
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE && (pType = type.asParameterizedType()).arguments().size() == 1 && (TypeUtil.isA(index, cl, type, JDKConstants.COMPLETION_STAGE_TYPE) || TypeUtil.isA(index, cl, type, MutinyConstants.UNI_TYPE))) {
            return pType.arguments().get(0);
        }
        for (AnnotationScannerExtension extension : extensions) {
            Type asyncType = extension.resolveAsyncType(type);
            if (asyncType == null) continue;
            return asyncType;
        }
        return type;
    }

    private static Discriminator readDiscriminator(IndexView index, ClassLoader cl, String propertyName, AnnotationInstance[] annotation) {
        if (propertyName == null && annotation == null) {
            return null;
        }
        DiscriminatorImpl discriminator = new DiscriminatorImpl();
        if (propertyName != null) {
            discriminator.setPropertyName(propertyName);
        }
        if (annotation != null) {
            IoLogging.log.annotationsList("@DiscriminatorMapping");
            for (AnnotationInstance nested : annotation) {
                ClassType schemaType;
                Schema schema;
                String propertyValue = JandexUtil.stringValue(nested, "value");
                AnnotationValue schemaValue = nested.value("schema");
                String schemaRef = schemaValue != null ? ((schema = SchemaFactory.introspectClassToSchema(index, cl, schemaType = schemaValue.asClass().asClassType(), true)) != null ? schema.getRef() : null) : null;
                if (propertyValue == null && schemaRef != null) {
                    propertyValue = ModelUtil.nameFromRef(schemaRef);
                }
                discriminator.addMapping(propertyValue, schemaRef);
            }
        }
        return discriminator;
    }
}

