/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.servervariable;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.servers.ServerVariableImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionConstant;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ServerVariableReader {
    private ServerVariableReader() {
    }

    public static Map<String, ServerVariable> readServerVariables(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.log.annotationsArray("@ServerVariable");
        AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
        LinkedHashMap<String, ServerVariable> variables = new LinkedHashMap<String, ServerVariable>();
        for (AnnotationInstance serverVariableAnno : nestedArray) {
            String name = JandexUtil.stringValue(serverVariableAnno, "name");
            if (name == null) continue;
            variables.put(name, ServerVariableReader.readServerVariable(serverVariableAnno));
        }
        return variables;
    }

    public static Map<String, ServerVariable> readServerVariables(JsonNode node) {
        if (node == null) {
            return null;
        }
        IoLogging.log.jsonNodeMap("ServerVariable");
        LinkedHashMap<String, ServerVariable> variables = new LinkedHashMap<String, ServerVariable>();
        Iterator<String> iterator = node.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = iterator.next();
            if (ExtensionConstant.isExtensionField(fieldName)) continue;
            JsonNode varNode = node.get(fieldName);
            variables.put(fieldName, ServerVariableReader.readServerVariable(varNode));
        }
        return variables;
    }

    private static ServerVariable readServerVariable(AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.log.singleAnnotation("@ServerVariable");
        ServerVariableImpl variable = new ServerVariableImpl();
        variable.setDescription(JandexUtil.stringValue(annotationInstance, "description"));
        variable.setEnumeration(JandexUtil.stringListValue(annotationInstance, "enumeration").orElse(null));
        variable.setDefaultValue(JandexUtil.stringValue(annotationInstance, "defaultValue"));
        return variable;
    }

    private static ServerVariable readServerVariable(JsonNode node) {
        if (node == null) {
            return null;
        }
        IoLogging.log.singleJsonNode("ServerVariable");
        ServerVariableImpl variable = new ServerVariableImpl();
        JsonNode enumNode = node.get("enum");
        if (enumNode != null && enumNode.isArray()) {
            ArrayList<String> enums = new ArrayList<String>(enumNode.size());
            for (JsonNode n : enumNode) {
                enums.add(n.asText());
            }
            variable.setEnumeration(enums);
        }
        variable.setDefaultValue(JsonUtil.stringProperty(node, "default"));
        variable.setDescription(JsonUtil.stringProperty(node, "description"));
        ExtensionReader.readExtensions(node, variable);
        return variable;
    }
}

