/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.constants.JsonbConstants;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.IgnoreResolver;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class TypeResolver {
    private static final Type BOOLEAN_TYPE = Type.create(DotName.createSimple(Boolean.class.getName()), Type.Kind.CLASS);
    static final String METHOD_PREFIX_GET = "get";
    static final String METHOD_PREFIX_IS = "is";
    static final String METHOD_PREFIX_SET = "set";
    private final Deque<Map<String, Type>> resolutionStack;
    private final String propertyName;
    private FieldInfo field;
    private MethodInfo readMethod;
    private MethodInfo writeMethod;
    private boolean ignored = false;
    private boolean exposed = false;
    private boolean readOnly = false;
    private boolean writeOnly = false;
    private Type leaf;
    private static final Comparator<AnnotationTarget> targetComparator = (t1, t2) -> {
        int result = TypeResolver.compareAnnotation(t1, t2, SchemaConstant.DOTNAME_SCHEMA);
        if (result != 0) {
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, JsonbConstants.JSONB_PROPERTY);
        if (result != 0) {
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, JacksonConstants.JSON_PROPERTY);
        if (result != 0) {
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, JaxbConstants.XML_ELEMENT);
        if (result != 0) {
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, JaxbConstants.XML_ATTRIBUTE);
        if (result != 0) {
            return result;
        }
        if (t1.kind() == AnnotationTarget.Kind.FIELD) {
            return -1;
        }
        if (t2.kind() == AnnotationTarget.Kind.FIELD) {
            return 1;
        }
        if (TypeResolver.isAccessor(t1.asMethod()) && !TypeResolver.isAccessor(t2.asMethod())) {
            return -1;
        }
        return 0;
    };
    private Queue<AnnotationTarget> targets = new PriorityQueue<AnnotationTarget>(targetComparator);

    private static int compareAnnotation(AnnotationTarget t1, AnnotationTarget t2, DotName annotationName) {
        boolean hasAnno1 = TypeUtil.hasAnnotation(t1, annotationName);
        boolean hasAnno2 = TypeUtil.hasAnnotation(t2, annotationName);
        if (hasAnno1) {
            if (!hasAnno2) {
                return -1;
            }
        } else if (hasAnno2) {
            return 1;
        }
        return 0;
    }

    private TypeResolver(String propertyName, FieldInfo field, Deque<Map<String, Type>> resolutionStack) {
        this.propertyName = propertyName;
        this.field = field;
        this.resolutionStack = resolutionStack;
        if (field != null) {
            this.leaf = field.type();
            this.targets.add(field);
        } else {
            this.leaf = null;
        }
    }

    public ClassInfo getDeclaringClass() {
        return TypeUtil.getDeclaringClass(this.getAnnotationTarget());
    }

    public AnnotationTarget getAnnotationTarget() {
        return this.targets.peek();
    }

    public Type getUnresolvedType() {
        return this.leaf;
    }

    public String getPropertyName() {
        AnnotationTarget target = this.getAnnotationTarget();
        String name = (String)TypeUtil.getAnnotationValue(target, SchemaConstant.DOTNAME_SCHEMA, "name");
        if (name != null) {
            return name;
        }
        name = (String)TypeUtil.getAnnotationValue(target, JsonbConstants.JSONB_PROPERTY, "value");
        if (name != null) {
            return name;
        }
        name = (String)TypeUtil.getAnnotationValue(target, JacksonConstants.JSON_PROPERTY, "value");
        if (name != null) {
            return name;
        }
        name = (String)TypeUtil.getAnnotationValue(target, JaxbConstants.XML_ELEMENT, "name");
        if (name != null) {
            return name;
        }
        name = (String)TypeUtil.getAnnotationValue(target, JaxbConstants.XML_ATTRIBUTE, "name");
        if (name != null) {
            return name;
        }
        return this.propertyName;
    }

    public FieldInfo getField() {
        return this.field;
    }

    private void setField(FieldInfo field) {
        this.field = field;
    }

    public MethodInfo getReadMethod() {
        return this.readMethod;
    }

    private void setReadMethod(MethodInfo readMethod) {
        if (this.readMethod != null) {
            this.targets.remove(this.readMethod);
        }
        this.readMethod = readMethod;
        if (readMethod != null) {
            this.leaf = readMethod.returnType();
            this.targets.add(readMethod);
        }
    }

    public MethodInfo getWriteMethod() {
        return this.writeMethod;
    }

    private void setWriteMethod(MethodInfo writeMethod) {
        if (this.writeMethod != null) {
            this.targets.remove(this.writeMethod);
        }
        this.writeMethod = writeMethod;
        if (writeMethod != null) {
            this.leaf = writeMethod.parameters().get(0);
            this.targets.add(writeMethod);
        }
    }

    public Type resolveType() {
        return this.getResolvedType(this.leaf);
    }

    public boolean isIgnored() {
        return this.ignored || this.readOnly && this.readMethod == null || this.writeOnly && this.writeMethod == null;
    }

    public Type getResolvedType(Type fieldType) {
        Type current = TypeUtil.resolveWildcard(fieldType);
        for (Map<String, Type> map : this.resolutionStack) {
            String varName = null;
            switch (current.kind()) {
                case TYPE_VARIABLE: {
                    varName = current.asTypeVariable().identifier();
                    break;
                }
                case UNRESOLVED_TYPE_VARIABLE: {
                    varName = current.asUnresolvedTypeVariable().identifier();
                    break;
                }
            }
            if (varName == null || !map.containsKey(varName)) continue;
            current = map.get(varName);
        }
        return current;
    }

    public Type getResolvedType(ParameterizedType type) {
        if (type.arguments().stream().noneMatch(arg -> arg.kind() == Type.Kind.WILDCARD_TYPE)) {
            return ParameterizedType.create(type.name(), (Type[])type.arguments().stream().map(this::getResolvedType).toArray(Type[]::new), null);
        }
        return this.getResolvedType((Type)type);
    }

    public static Map<String, TypeResolver> getAllFields(AugmentedIndexView index, IgnoreResolver ignoreResolver, Type leaf, ClassInfo leafKlazz, AnnotationTarget reference) {
        Map<ClassInfo, Type> chain = JandexUtil.inheritanceChain(index, leafKlazz, leaf);
        LinkedHashMap<String, TypeResolver> properties = new LinkedHashMap<String, TypeResolver>();
        ArrayDeque<Map<String, Type>> stack = new ArrayDeque<Map<String, Type>>();
        for (Map.Entry<ClassInfo, Type> entry : chain.entrySet()) {
            ClassInfo currentClass = entry.getKey();
            Type currentType = entry.getValue();
            if (currentType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                Map<String, Type> resMap = TypeResolver.buildParamTypeResolutionMap(currentClass, currentType.asParameterizedType());
                stack.push(resMap);
            }
            currentClass.fields().stream().filter(TypeResolver::acceptField).forEach(field -> TypeResolver.scanField(properties, field, stack, reference, ignoreResolver));
            currentClass.methods().stream().filter(TypeResolver::acceptMethod).forEach(method -> TypeResolver.scanMethod(properties, method, stack, reference, ignoreResolver));
            TypeResolver.interfaces(index, currentClass).stream().map(index::getClass).filter(Objects::nonNull).flatMap(clazz -> clazz.methods().stream()).forEach(method -> TypeResolver.scanMethod(properties, method, stack, reference, ignoreResolver));
        }
        return TypeResolver.sorted(properties, chain.keySet());
    }

    private static boolean acceptMethod(MethodInfo method) {
        return !Modifier.isStatic(method.flags()) && !method.name().equals("getClass");
    }

    private static boolean acceptField(FieldInfo field) {
        return !Modifier.isStatic(field.flags());
    }

    private static Set<Type> interfaces(AugmentedIndexView index, ClassInfo klass) {
        LinkedHashSet<Type> interfaces = new LinkedHashSet<Type>();
        for (Type type : klass.interfaceTypes()) {
            interfaces.add(type);
            if (!index.containsClass(type)) continue;
            interfaces.addAll(TypeResolver.interfaces(index, index.getClass(type)));
        }
        return interfaces;
    }

    private void processVisibility(AnnotationTarget target, AnnotationTarget reference, IgnoreResolver ignoreResolver) {
        if (this.exposed || this.ignored) {
            return;
        }
        if (this.isUnhidden(target)) {
            this.exposed = true;
            return;
        }
        IgnoreResolver.Visibility visibility = ignoreResolver.isIgnore(target, reference);
        switch (visibility) {
            case EXPOSED: {
                this.exposed = true;
                break;
            }
            case IGNORED: {
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    if (TypeResolver.isAccessor(target.asMethod())) {
                        this.writeOnly = true;
                    } else {
                        this.readOnly = true;
                    }
                    if (!this.readOnly || !this.writeOnly) break;
                    this.ignored = true;
                    break;
                }
                this.ignored = true;
                break;
            }
        }
    }

    boolean isUnhidden(AnnotationTarget target) {
        Boolean hidden;
        AnnotationInstance schemaAnnotation;
        return target != null && (schemaAnnotation = TypeUtil.getSchemaAnnotation(target)) != null && ((hidden = (Boolean)JandexUtil.value(schemaAnnotation, "hidden")) == null || hidden == false);
    }

    private static void scanField(Map<String, TypeResolver> properties, FieldInfo field, Deque<Map<String, Type>> stack, AnnotationTarget reference, IgnoreResolver ignoreResolver) {
        TypeResolver resolver;
        String propertyName = field.name();
        if (properties.containsKey(propertyName)) {
            resolver = properties.get(propertyName);
            if (resolver.getField() == null && (Modifier.isPublic(field.flags()) || Modifier.isProtected(field.flags()))) {
                resolver.setField(field);
            }
        } else {
            resolver = new TypeResolver(propertyName, field, new ArrayDeque<Map<String, Type>>(stack));
            properties.put(propertyName, resolver);
        }
        resolver.processVisibility(field, reference, ignoreResolver);
    }

    private static void scanMethod(Map<String, TypeResolver> properties, MethodInfo method, Deque<Map<String, Type>> stack, AnnotationTarget reference, IgnoreResolver ignoreResolver) {
        TypeResolver resolver;
        Type returnType = method.returnType();
        Type propertyType = null;
        if (TypeResolver.isAccessor(method)) {
            propertyType = returnType;
        } else if (TypeResolver.isMutator(method)) {
            propertyType = method.parameters().get(0);
        }
        if (propertyType != null && (resolver = TypeResolver.updateTypeResolvers(properties, stack, method, propertyType)) != null) {
            resolver.processVisibility(method, reference, ignoreResolver);
        }
    }

    private static TypeResolver updateTypeResolvers(Map<String, TypeResolver> properties, Deque<Map<String, Type>> stack, MethodInfo method, Type propertyType) {
        TypeResolver resolver;
        String methodName = method.name();
        int nameStart = TypeResolver.methodNamePrefix(method).length();
        boolean isWriteMethod = TypeResolver.isMutator(method);
        if (methodName.length() == nameStart) {
            return null;
        }
        String propertyName = nameStart > 0 ? Character.toLowerCase(methodName.charAt(nameStart)) + methodName.substring(nameStart + 1) : methodName;
        if (properties.containsKey(propertyName)) {
            resolver = properties.get(propertyName);
            if (!TypeUtil.equalTypes(resolver.getUnresolvedType(), propertyType)) {
                return resolver;
            }
        } else {
            resolver = new TypeResolver(propertyName, null, new ArrayDeque<Map<String, Type>>(stack));
            properties.put(propertyName, resolver);
        }
        if (isWriteMethod) {
            if (TypeResolver.isHigherPriority(method, resolver.getWriteMethod())) {
                resolver.setWriteMethod(method);
            }
        } else if (TypeResolver.isHigherPriority(method, resolver.getReadMethod())) {
            resolver.setReadMethod(method);
        }
        return resolver;
    }

    private static boolean isAccessor(MethodInfo method) {
        Type returnType = method.returnType();
        if (!method.parameters().isEmpty() || Type.Kind.VOID.equals((Object)returnType.kind())) {
            return false;
        }
        String namePrefix = TypeResolver.methodNamePrefix(method);
        if (METHOD_PREFIX_GET.equals(namePrefix)) {
            return true;
        }
        if (METHOD_PREFIX_IS.equals(namePrefix) && TypeUtil.equalTypes(returnType, BOOLEAN_TYPE)) {
            return true;
        }
        return TypeUtil.hasAnnotation(method, SchemaConstant.DOTNAME_SCHEMA);
    }

    private static boolean isMutator(MethodInfo method) {
        Type returnType = method.returnType();
        if (method.parameters().size() != 1 || !Type.Kind.VOID.equals((Object)returnType.kind())) {
            return false;
        }
        return METHOD_PREFIX_SET.equals(TypeResolver.methodNamePrefix(method)) || TypeUtil.hasAnnotation(method, SchemaConstant.DOTNAME_SCHEMA);
    }

    private static String methodNamePrefix(MethodInfo method) {
        String methodName = method.name();
        if (methodName.startsWith(METHOD_PREFIX_GET)) {
            return METHOD_PREFIX_GET;
        }
        if (methodName.startsWith(METHOD_PREFIX_IS)) {
            return METHOD_PREFIX_IS;
        }
        if (methodName.startsWith(METHOD_PREFIX_SET)) {
            return METHOD_PREFIX_SET;
        }
        return "";
    }

    private static boolean isHigherPriority(MethodInfo newMethod, MethodInfo oldMethod) {
        if (oldMethod == null) {
            return true;
        }
        if (Modifier.isInterface(newMethod.declaringClass().flags())) {
            return targetComparator.compare(newMethod, oldMethod) < 0;
        }
        return false;
    }

    private static Map<String, TypeResolver> sorted(Map<String, TypeResolver> properties, Set<ClassInfo> chainKeys) {
        ArrayList<ClassInfo> chain = new ArrayList<ClassInfo>(chainKeys);
        Collections.reverse(chain);
        List order = chain.stream().map(TypeResolver::propertyOrder).flatMap(Collection::stream).collect(Collectors.toList());
        return properties.entrySet().stream().sorted((e1, e2) -> {
            int pIndex2;
            TypeResolver r1 = (TypeResolver)e1.getValue();
            TypeResolver r2 = (TypeResolver)e2.getValue();
            ClassInfo c1 = r1.getDeclaringClass();
            ClassInfo c2 = r2.getDeclaringClass();
            int pIndex1 = order.indexOf(r1.getPropertyName());
            if (pIndex1 < 0) {
                pIndex1 = order.indexOf(e1.getKey());
            }
            if ((pIndex2 = order.indexOf(r2.getPropertyName())) < 0) {
                pIndex2 = order.indexOf(e2.getKey());
            }
            if (pIndex1 > -1) {
                if (pIndex2 < 0) {
                    return -1;
                }
                return Integer.compare(pIndex1, pIndex2);
            }
            if (pIndex2 > -1) {
                return 1;
            }
            int cIndex1 = chain.indexOf(c1);
            int cIndex2 = chain.indexOf(c2);
            return Integer.compare(cIndex1, cIndex2);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static List<String> propertyOrder(ClassInfo clazz) {
        AnnotationValue orderArray = null;
        AnnotationInstance propertyOrder = clazz.classAnnotation(JsonbConstants.JSONB_PROPERTY_ORDER);
        if (propertyOrder != null) {
            orderArray = propertyOrder.value();
        } else {
            propertyOrder = clazz.classAnnotation(JaxbConstants.XML_TYPE);
            if (propertyOrder != null) {
                orderArray = propertyOrder.value("propOrder");
            } else {
                propertyOrder = clazz.classAnnotation(JacksonConstants.JSON_PROPERTY_ORDER);
                if (propertyOrder != null) {
                    orderArray = propertyOrder.value();
                }
            }
        }
        if (orderArray != null) {
            return Arrays.asList(orderArray.asStringArray());
        }
        return Collections.emptyList();
    }

    private static Map<String, Type> buildParamTypeResolutionMap(ClassInfo klazz, ParameterizedType parameterizedType) {
        List<TypeVariable> typeVariables = klazz.typeParameters();
        List<Type> arguments = parameterizedType.arguments();
        if (arguments.size() != typeVariables.size()) {
            DataObjectLogging.log.classNotAvailable(typeVariables, arguments);
        }
        LinkedHashMap<String, Type> resolutionMap = new LinkedHashMap<String, Type>();
        for (int i = 0; i < arguments.size(); ++i) {
            TypeVariable typeVar = typeVariables.get(i);
            Type arg = arguments.get(i);
            resolutionMap.put(typeVar.identifier(), arg);
        }
        return resolutionMap;
    }
}

