/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.reactivex.Flowable;
import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.extension.LegacyEmitterImpl;
import io.smallrye.reactive.messaging.helpers.TypeUtils;
import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class ChannelProducer {
    @Inject
    ChannelRegistry channelRegistry;

    @Produces
    @Typed(value={Flowable.class})
    @Channel(value="")
    <T> Flowable<T> produceFlowable(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable(first, Message.class)) {
            return (Flowable)ChannelProducer.cast(Flowable.fromPublisher(this.getPublisher(injectionPoint)));
        }
        return (Flowable)ChannelProducer.cast(Flowable.fromPublisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    @Produces
    @Channel(value="")
    <T> Multi<T> produceMulti(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable(first, Message.class)) {
            return (Multi)ChannelProducer.cast(Multi.createFrom().publisher(this.getPublisher(injectionPoint)));
        }
        return (Multi)ChannelProducer.cast(Multi.createFrom().publisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    @Produces
    @Deprecated
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> Flowable<T> producePublisherWithLegacyChannelAnnotation(InjectionPoint injectionPoint) {
        return this.produceFlowable(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> PublisherBuilder<T> producePublisherBuilder(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable(first, Message.class)) {
            return (PublisherBuilder)ChannelProducer.cast(ReactiveStreams.fromPublisher(this.getPublisher(injectionPoint)));
        }
        return (PublisherBuilder)ChannelProducer.cast(ReactiveStreams.fromPublisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    @Produces
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> PublisherBuilder<T> producePublisherBuilderWithLegacyChannelAnnotation(InjectionPoint injectionPoint) {
        return this.producePublisherBuilder(injectionPoint);
    }

    @Produces
    @Channel(value="")
    <T> org.eclipse.microprofile.reactive.messaging.Emitter<T> produceEmitter(InjectionPoint injectionPoint) {
        org.eclipse.microprofile.reactive.messaging.Emitter emitter = this.getEmitter(injectionPoint);
        return (org.eclipse.microprofile.reactive.messaging.Emitter)ChannelProducer.cast(emitter);
    }

    @Produces
    @Channel(value="")
    <T> MutinyEmitter<T> produceMutinyEmitter(InjectionPoint injectionPoint) {
        MutinyEmitter emitter = this.getMutinyEmitter(injectionPoint);
        return (MutinyEmitter)ChannelProducer.cast(emitter);
    }

    @Produces
    @io.smallrye.reactive.messaging.annotations.Channel(value="")
    <T> Emitter<T> produceEmitterLegacy(InjectionPoint injectionPoint) {
        LegacyEmitterImpl emitter = new LegacyEmitterImpl(this.getEmitter(injectionPoint));
        return (Emitter)ChannelProducer.cast(emitter);
    }

    private Publisher<? extends Message> getPublisher(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        List<PublisherBuilder<Message<?>>> list = this.channelRegistry.getPublishers(name);
        if (list.isEmpty()) {
            throw ProviderExceptions.ex.illegalStateForStream(name, this.channelRegistry.getIncomingNames());
        }
        return list.get(0).buildRs();
    }

    private org.eclipse.microprofile.reactive.messaging.Emitter getEmitter(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        org.eclipse.microprofile.reactive.messaging.Emitter<?> emitter = this.channelRegistry.getEmitter(name);
        if (emitter == null) {
            throw ProviderExceptions.ex.illegalStateForEmitter(name, this.channelRegistry.getEmitterNames());
        }
        return emitter;
    }

    private MutinyEmitter getMutinyEmitter(InjectionPoint injectionPoint) {
        String name = ChannelProducer.getChannelName(injectionPoint);
        MutinyEmitter<?> emitter = this.channelRegistry.getMutinyEmitter(name);
        if (emitter == null) {
            throw ProviderExceptions.ex.illegalStateForEmitter(name, this.channelRegistry.getEmitterNames());
        }
        return emitter;
    }

    private Type getFirstParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    static String getChannelName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (qualifier.annotationType().equals(Channel.class)) {
                return ((Channel)qualifier).value();
            }
            if (!qualifier.annotationType().equals(io.smallrye.reactive.messaging.annotations.Channel.class)) continue;
            return ((io.smallrye.reactive.messaging.annotations.Channel)qualifier).value();
        }
        throw ProviderExceptions.ex.illegalStateForAnnotationNotFound("@Channel", injectionPoint);
    }

    static Channel getChannelQualifier(InjectionPoint injectionPoint) {
        for (final Annotation qualifier : injectionPoint.getQualifiers()) {
            if (qualifier.annotationType().equals(Channel.class)) {
                return (Channel)qualifier;
            }
            if (!qualifier.annotationType().equals(io.smallrye.reactive.messaging.annotations.Channel.class)) continue;
            return new Channel(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return Channel.class;
                }

                @Override
                public String value() {
                    return ((io.smallrye.reactive.messaging.annotations.Channel)qualifier).value();
                }
            };
        }
        return null;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }
}

