/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.grpc.Context;
import io.opentelemetry.OpenTelemetry;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaCloudEventMetadata;
import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.KafkaRecord;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.impl.ce.KafkaCloudEventHelper;
import io.smallrye.reactive.messaging.kafka.tracing.HeaderExtractAdapter;
import io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.kafka.common.header.Headers;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class IncomingKafkaRecord<K, T>
implements KafkaRecord<K, T> {
    private Metadata metadata;
    private final IncomingKafkaRecordMetadata<K, T> kafkaMetadata;
    private final KafkaCommitHandler commitHandler;
    private final KafkaFailureHandler onNack;
    private final T payload;

    public IncomingKafkaRecord(KafkaConsumerRecord<K, T> record, KafkaCommitHandler commitHandler, KafkaFailureHandler onNack, boolean cloudEventEnabled, boolean tracingEnabled) {
        this.commitHandler = commitHandler;
        this.kafkaMetadata = new IncomingKafkaRecordMetadata<K, T>(record);
        ArrayList<Object> meta = new ArrayList<Object>();
        meta.add(this.kafkaMetadata);
        Object payload = null;
        boolean payloadSet = false;
        if (cloudEventEnabled) {
            KafkaCloudEventHelper.CloudEventMode mode = KafkaCloudEventHelper.getCloudEventMode(record);
            switch (mode) {
                case NOT_A_CLOUD_EVENT: {
                    break;
                }
                case STRUCTURED: {
                    IncomingKafkaCloudEventMetadata<K, T> event = KafkaCloudEventHelper.createFromStructuredCloudEvent(record);
                    meta.add(event);
                    payloadSet = true;
                    payload = event.getData();
                    break;
                }
                case BINARY: {
                    meta.add(KafkaCloudEventHelper.createFromBinaryCloudEvent(record));
                }
            }
        }
        if (tracingEnabled) {
            TracingMetadata tracingMetadata = TracingMetadata.empty();
            if (record.headers() != null) {
                Context context = OpenTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), this.kafkaMetadata.getHeaders(), HeaderExtractAdapter.GETTER);
                tracingMetadata = TracingMetadata.withPrevious(context);
            }
            meta.add(tracingMetadata);
        }
        this.metadata = Metadata.from(meta);
        this.onNack = onNack;
        this.payload = payload == null && !payloadSet ? record.value() : payload;
    }

    @Override
    public T getPayload() {
        return this.payload;
    }

    @Override
    public K getKey() {
        return this.kafkaMetadata.getKey();
    }

    @Override
    public String getTopic() {
        return this.kafkaMetadata.getTopic();
    }

    @Override
    public int getPartition() {
        return this.kafkaMetadata.getPartition();
    }

    @Override
    public Instant getTimestamp() {
        return this.kafkaMetadata.getTimestamp();
    }

    @Override
    public Headers getHeaders() {
        return this.kafkaMetadata.getHeaders();
    }

    public long getOffset() {
        return this.kafkaMetadata.getOffset();
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    @Override
    public CompletionStage<Void> ack() {
        return this.commitHandler.handle(this);
    }

    @Override
    public CompletionStage<Void> nack(Throwable reason) {
        return this.onNack.handle(this, reason);
    }

    public synchronized void injectTracingMetadata(TracingMetadata tracingMetadata) {
        this.metadata = this.metadata.with(tracingMetadata);
    }
}

