/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class KafkaConnectorCommonConfiguration {
    protected final Config config;

    public KafkaConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return this.config.getValue("channel-name", String.class);
    }

    public String getBootstrapServers() {
        return this.config.getOptionalValue("bootstrap.servers", String.class).orElseGet(() -> this.getFromAliasWithDefaultValue("kafka.bootstrap.servers", String.class, "localhost:9092"));
    }

    public Optional<String> getTopic() {
        return this.config.getOptionalValue("topic", String.class);
    }

    public Boolean getHealthEnabled() {
        return this.config.getOptionalValue("health-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Boolean getHealthReadinessEnabled() {
        return this.config.getOptionalValue("health-readiness-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public Long getHealthReadinessTimeout() {
        return this.config.getOptionalValue("health-readiness-timeout", Long.class).orElse(Long.valueOf("2000"));
    }

    public Boolean getTracingEnabled() {
        return this.config.getOptionalValue("tracing-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public void validate() {
    }
}

