/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import io.vertx.ext.web.impl.HttpServerRequestWrapper;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouteState;
import io.vertx.ext.web.impl.RouterImpl;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class RoutingContextImplBase
implements RoutingContext {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingContextImplBase.class);
    private final Set<RouteImpl> routes;
    protected final String mountPoint;
    protected final HttpServerRequest request;
    protected Iterator<RouteImpl> iter;
    protected RouteState currentRoute;
    private AtomicInteger currentRouteNextHandlerIndex;
    private AtomicInteger currentRouteNextFailureHandlerIndex;
    int matchFailure;
    int matchRest = -1;
    boolean matchNormalized;

    RoutingContextImplBase(String mountPoint, HttpServerRequest request, Set<RouteImpl> routes) {
        this.mountPoint = mountPoint;
        this.request = new HttpServerRequestWrapper(request);
        this.routes = routes;
        this.iter = routes.iterator();
        this.currentRouteNextHandlerIndex = new AtomicInteger(0);
        this.currentRouteNextFailureHandlerIndex = new AtomicInteger(0);
        this.resetMatchFailure();
    }

    @Override
    public String mountPoint() {
        return this.mountPoint;
    }

    @Override
    public Route currentRoute() {
        return this.currentRoute.getRoute();
    }

    int currentRouteNextHandlerIndex() {
        return this.currentRouteNextHandlerIndex.intValue();
    }

    int currentRouteNextFailureHandlerIndex() {
        return this.currentRouteNextFailureHandlerIndex.intValue();
    }

    void restart() {
        this.iter = this.routes.iterator();
        this.currentRoute = null;
        this.next();
    }

    boolean iterateNext() {
        boolean failed = this.failed();
        if (this.currentRoute != null) {
            try {
                if (!failed && this.currentRoute.hasNextContextHandler(this)) {
                    this.currentRouteNextHandlerIndex.incrementAndGet();
                    this.resetMatchFailure();
                    this.currentRoute.handleContext(this);
                    return true;
                }
                if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                    this.currentRouteNextFailureHandlerIndex.incrementAndGet();
                    this.currentRoute.handleFailure(this);
                    return true;
                }
            }
            catch (Throwable t) {
                this.handleInHandlerRuntimeFailure(this.currentRoute.getRouter(), failed, t);
                return true;
            }
        }
        while (this.iter.hasNext()) {
            RouteState routeState = this.iter.next().state();
            this.currentRouteNextHandlerIndex.set(0);
            this.currentRouteNextFailureHandlerIndex.set(0);
            try {
                int matchResult = routeState.matches(this, this.mountPoint(), failed);
                if (matchResult == 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Route matches: " + routeState);
                    }
                    this.resetMatchFailure();
                    try {
                        this.currentRoute = routeState;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Calling the " + (failed ? "failure" : "") + " handler");
                        }
                        if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                            this.currentRouteNextFailureHandlerIndex.incrementAndGet();
                            routeState.handleFailure(this);
                        } else {
                            if (!this.currentRoute.hasNextContextHandler(this)) continue;
                            this.currentRouteNextHandlerIndex.incrementAndGet();
                            routeState.handleContext(this);
                        }
                    }
                    catch (Throwable t) {
                        this.handleInHandlerRuntimeFailure(routeState.getRouter(), failed, t);
                    }
                    return true;
                }
                if (matchResult == 405) {
                    if (this.matchFailure != 404) continue;
                    this.matchFailure = matchResult;
                    continue;
                }
                if (matchResult == 404) continue;
                this.matchFailure = matchResult;
            }
            catch (Throwable e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"IllegalArgumentException thrown during iteration", e);
                }
                if (!this.response().ended()) {
                    this.unhandledFailure(e instanceof IllegalArgumentException ? 400 : -1, e, routeState.getRouter());
                }
                return true;
            }
        }
        return false;
    }

    private void handleInHandlerRuntimeFailure(RouterImpl router, boolean failed, Throwable t) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Throwable thrown from handler", t);
        }
        if (!failed) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failing the routing");
            }
            this.fail(t);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failure in handling failure");
            }
            this.unhandledFailure(-1, t, router);
        }
    }

    protected void unhandledFailure(int statusCode, Throwable failure, RouterImpl router) {
        int code = statusCode != -1 ? statusCode : (failure instanceof HttpStatusException ? ((HttpStatusException)failure).getStatusCode() : 500);
        Handler<RoutingContext> errorHandler = router.getErrorHandlerByStatusCode(code);
        if (errorHandler != null) {
            try {
                errorHandler.handle(this);
            }
            catch (Throwable t) {
                LOG.error((Object)"Error in error handler", t);
            }
        }
        if (!this.response().ended() && !this.response().closed()) {
            try {
                this.response().setStatusCode(code);
            }
            catch (IllegalArgumentException e) {
                this.response().setStatusMessage(HttpResponseStatus.valueOf(code).reasonPhrase()).setStatusCode(code);
            }
            this.response().end(this.response().getStatusMessage());
        }
    }

    private void resetMatchFailure() {
        this.matchFailure = 404;
    }
}

