/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientEventDispatcher;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;

public class AddClientListenerOperation
extends RetryOnFailureOperation<Short> {
    public final byte[] listenerId;
    public final Object listener;
    private final String cacheNameString;
    private final ClientListenerNotifier listenerNotifier;
    private final byte[][] filterFactoryParams;
    private final byte[][] converterFactoryParams;

    protected AddClientListenerOperation(Codec codec, ChannelFactory channelFactory, String cacheName, AtomicInteger topologyId, int flags, Configuration cfg, ClientListenerNotifier listenerNotifier, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, DataFormat dataFormat) {
        this(codec, channelFactory, cacheName, topologyId, flags, cfg, AddClientListenerOperation.generateListenerId(), listenerNotifier, listener, filterFactoryParams, converterFactoryParams, dataFormat);
    }

    private AddClientListenerOperation(Codec codec, ChannelFactory channelFactory, String cacheName, AtomicInteger topologyId, int flags, Configuration cfg, byte[] listenerId, ClientListenerNotifier listenerNotifier, Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams, DataFormat dataFormat) {
        super((short)37, (short)38, codec, channelFactory, RemoteCacheManager.cacheNameBytes(cacheName), topologyId, flags, cfg, dataFormat);
        this.listenerId = listenerId;
        this.listenerNotifier = listenerNotifier;
        this.listener = listener;
        this.filterFactoryParams = filterFactoryParams;
        this.converterFactoryParams = converterFactoryParams;
        this.cacheNameString = cacheName;
    }

    public AddClientListenerOperation copy() {
        return new AddClientListenerOperation(this.codec, this.channelFactory, this.cacheNameString, this.header.topologyId(), this.flags, this.cfg, this.listenerId, this.listenerNotifier, this.listener, this.filterFactoryParams, this.converterFactoryParams, this.dataFormat);
    }

    private static byte[] generateListenerId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] listenerId = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(listenerId);
        bb.putLong(random.nextLong());
        bb.putLong(random.nextLong());
        return listenerId;
    }

    private ClientListener extractClientListener() {
        ClientListener l = ReflectionUtil.getAnnotation(this.listener.getClass(), ClientListener.class);
        if (l == null) {
            throw Log.HOTROD.missingClientListenerAnnotation(this.listener.getClass().getName());
        }
        return l;
    }

    public String getCacheName() {
        return this.cacheNameString;
    }

    @Override
    protected void executeOperation(Channel channel) {
        if (!channel.isActive()) {
            this.channelInactive(channel);
            return;
        }
        ClientListener clientListener = this.extractClientListener();
        channel.pipeline().get(HeaderDecoder.class).registerOperation(channel, this);
        this.listenerNotifier.addDispatcher(ClientEventDispatcher.create(this, ChannelRecord.of(channel).getUnresolvedAddress(), () -> this.cleanup(channel)));
        ByteBuf buf = channel.alloc().buffer();
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.listenerId);
        this.codec.writeClientListenerParams(buf, clientListener, this.filterFactoryParams, this.converterFactoryParams);
        this.codec.writeClientListenerInterests(buf, ClientEventDispatcher.findMethods(this.listener).keySet());
        channel.writeAndFlush(buf);
    }

    private void cleanup(Channel channel) {
        channel.eventLoop().execute(() -> {
            HeaderDecoder decoder;
            if (!this.codec.allowOperationsAndEvents() && channel.isOpen()) {
                this.channelFactory.releaseChannel(channel);
            }
            if ((decoder = channel.pipeline().get(HeaderDecoder.class)) != null) {
                decoder.removeListener(this.listenerId);
            }
        });
    }

    @Override
    public void releaseChannel(Channel channel) {
        if (this.codec.allowOperationsAndEvents()) {
            super.releaseChannel(channel);
        }
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (!HotRodConstants.isSuccess(status)) {
            this.listenerNotifier.removeClientListener(this.listenerId);
            throw Log.HOTROD.failedToAddListener(this.listener, status);
        }
        decoder.addListener(this.listenerId);
        this.listenerNotifier.startClientListener(this.listenerId);
        this.complete(status);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        if (!this.isDone()) {
            this.listenerNotifier.removeClientListener(this.listenerId);
        }
        return super.completeExceptionally(ex);
    }

    public void postponeTimeout(Channel channel) {
        assert (!this.isDone());
        this.timeoutFuture.cancel(false);
        this.timeoutFuture = null;
        this.scheduleTimeout(channel);
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append("listenerId=").append(Util.printArray(this.listenerId));
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }
}

