/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.MessagingUtils;
import org.kie.kogito.trusty.service.messaging.incoming.ModelIdCreator;
import org.kie.kogito.trusty.service.messaging.outgoing.ExplainabilityRequestProducer;
import org.kie.kogito.trusty.service.models.MatchedExecutionHeaders;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TrustyServiceImpl
implements TrustyService {
    private static final Logger LOG = LoggerFactory.getLogger(TrustyServiceImpl.class);
    private boolean isExplainabilityEnabled;
    private ExplainabilityRequestProducer explainabilityRequestProducer;
    private TrustyStorageService storageService;

    TrustyServiceImpl() {
    }

    @Inject
    public TrustyServiceImpl(@ConfigProperty(name="trusty.explainability.enabled") Boolean isExplainabilityEnabled, ExplainabilityRequestProducer explainabilityRequestProducer, TrustyStorageService storageService) {
        this.isExplainabilityEnabled = Boolean.TRUE.equals(isExplainabilityEnabled);
        this.explainabilityRequestProducer = explainabilityRequestProducer;
        this.storageService = storageService;
    }

    void enableExplainability() {
        this.isExplainabilityEnabled = true;
    }

    @Override
    public MatchedExecutionHeaders getExecutionHeaders(OffsetDateTime from, OffsetDateTime to, int limit, int offset, String prefix) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        ArrayList filters = new ArrayList();
        filters.add(QueryFilterFactory.like("executionId", prefix + "*"));
        filters.add(QueryFilterFactory.greaterThanEqual("executionTimestamp", from.toInstant().toEpochMilli()));
        filters.add(QueryFilterFactory.lessThanEqual("executionTimestamp", to.toInstant().toEpochMilli()));
        ArrayList<Decision> result = new ArrayList<Decision>(storage.query().sort(Arrays.asList(QueryFilterFactory.orderBy("executionTimestamp", SortDirection.DESC))).filter(filters).execute());
        if (result.size() < offset) {
            throw new IllegalArgumentException("Out of bound start offset in result");
        }
        return new MatchedExecutionHeaders(result.subList(offset, Math.min(offset + limit, result.size())), result.size());
    }

    @Override
    public Decision getDecisionById(String executionId) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        if (!storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s does not exist in the storage.", executionId));
        }
        return storage.get(executionId);
    }

    @Override
    public void storeDecision(String executionId, Decision decision) {
        Storage<String, Decision> storage = this.storageService.getDecisionsStorage();
        if (storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A decision with ID %s is already present in the storage.", executionId));
        }
        storage.put(executionId, decision);
    }

    @Override
    public void updateDecision(String executionId, Decision decision) {
        this.storageService.getDecisionsStorage().put(executionId, decision);
    }

    @Override
    public void processDecision(String executionId, String serviceUrl, Decision decision) {
        this.storeDecision(executionId, decision);
        if (this.isExplainabilityEnabled) {
            Map inputs = decision.getInputs() != null ? (Map)decision.getInputs().stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), MessagingUtils.modelToTracingTypedValue(v.getValue())), HashMap::putAll) : Collections.emptyMap();
            Map outputs = decision.getOutcomes() != null ? (Map)decision.getOutcomes().stream().collect(HashMap::new, (m, v) -> m.put(v.getOutcomeName(), MessagingUtils.modelToTracingTypedValue(v.getOutcomeResult())), HashMap::putAll) : Collections.emptyMap();
            this.explainabilityRequestProducer.sendEvent(new ExplainabilityRequestDto(executionId, serviceUrl, this.createDecisionModelIdentifierDto(decision), inputs, outputs));
        }
    }

    @Override
    public ExplainabilityResult getExplainabilityResultById(String executionId) {
        Storage<String, ExplainabilityResult> storage = this.storageService.getExplainabilityResultStorage();
        if (!storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A explainability result with ID %s does not exist in the storage.", executionId));
        }
        return storage.get(executionId);
    }

    @Override
    public void storeExplainabilityResult(String executionId, ExplainabilityResult result) {
        Storage<String, ExplainabilityResult> storage = this.storageService.getExplainabilityResultStorage();
        if (storage.containsKey(executionId)) {
            throw new IllegalArgumentException(String.format("A explainability result with ID %s is already present in the storage.", executionId));
        }
        storage.put(executionId, result);
        LOG.info("Stored explainability result for execution {}", (Object)executionId);
    }

    @Override
    public void storeModel(String groupId, String artifactId, String version, String name, String namespace, String definition) {
        String identifier = ModelIdCreator.makeIdentifier(groupId, artifactId, version, name, namespace);
        Storage<String, String> storage = this.storageService.getModelStorage();
        if (storage.containsKey(identifier)) {
            throw new IllegalArgumentException(String.format("A model with ID %s is already present in the storage.", identifier));
        }
        storage.put(identifier, definition);
    }

    @Override
    public String getModelById(String modelId) {
        Storage<String, String> storage = this.storageService.getModelStorage();
        if (!storage.containsKey(modelId)) {
            throw new IllegalArgumentException(String.format("A model with ID %s does not exist in the storage.", modelId));
        }
        return storage.get(modelId);
    }

    private ModelIdentifierDto createDecisionModelIdentifierDto(Decision decision) {
        String resourceId = decision.getExecutedModelNamespace() + ":" + decision.getExecutedModelName();
        return new ModelIdentifierDto("dmn", resourceId);
    }
}

