/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.io.IOException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.trusty.service.TrustyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEventConsumer<E> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseEventConsumer.class);
    protected final TrustyService service;
    private final ObjectMapper mapper;

    protected BaseEventConsumer() {
        this(null, null);
    }

    public BaseEventConsumer(TrustyService service, ObjectMapper mapper) {
        this.service = service;
        this.mapper = mapper;
    }

    protected CompletionStage<Void> handleMessage(Message<String> message) {
        try {
            CloudEventUtils.decode(message.getPayload()).ifPresent(this::handleCloudEvent);
        }
        catch (Exception e) {
            LOG.error("Something unexpected happened during the processing of an Event. The event is discarded.", e);
        }
        return message.ack();
    }

    protected void handleCloudEvent(CloudEvent cloudEvent) {
        E payload;
        try {
            payload = this.mapper.readValue(cloudEvent.getData(), this.getEventType());
        }
        catch (IOException e) {
            LOG.error("Unable to deserialize CloudEvent data as " + this.getEventType().getType().getTypeName(), e);
            return;
        }
        if (payload == null) {
            LOG.error("Received CloudEvent with id {} from {} with empty data", (Object)cloudEvent.getId(), (Object)cloudEvent.getSource());
            return;
        }
        LOG.debug("Received CloudEvent with id {} from {}", (Object)cloudEvent.getId(), (Object)cloudEvent.getSource());
        this.internalHandleCloudEvent(cloudEvent, payload);
    }

    protected abstract TypeReference<E> getEventType();

    protected abstract void internalHandleCloudEvent(CloudEvent var1, E var2);
}

