/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.storage.infinispan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.infinispan.protostream.FileDescriptorSource;
import org.kie.kogito.trusty.storage.infinispan.DecisionInputMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DecisionMarshaller;
import org.kie.kogito.trusty.storage.infinispan.DecisionOutcomeMarshaller;
import org.kie.kogito.trusty.storage.infinispan.ExplainabilityResultMarshaller;
import org.kie.kogito.trusty.storage.infinispan.FeatureImportanceMarshaller;
import org.kie.kogito.trusty.storage.infinispan.MessageExceptionFieldMarshaller;
import org.kie.kogito.trusty.storage.infinispan.MessageMarshaller;
import org.kie.kogito.trusty.storage.infinispan.SaliencyMarshaller;
import org.kie.kogito.trusty.storage.infinispan.TypedVariableMarshaller;

@ApplicationScoped
public class ProtostreamProducer {
    @Inject
    ObjectMapper mapper;

    @Produces
    FileDescriptorSource kogitoTypesDescriptor() throws IOException {
        FileDescriptorSource source = new FileDescriptorSource();
        source.addProtoFile("decision.proto", Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/decision.proto"));
        return source;
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller decisionMarshaller() {
        return new DecisionMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller decisionInputMarshaller() {
        return new DecisionInputMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller decisionOutcomeMarshaller() {
        return new DecisionOutcomeMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller explainabilityResultMarshaller() {
        return new ExplainabilityResultMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller featureImportanceMarshaller() {
        return new FeatureImportanceMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller messageExceptionFieldMarshaller() {
        return new MessageExceptionFieldMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller messageMarshaller() {
        return new MessageMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller saliencyMarshaller() {
        return new SaliencyMarshaller(this.mapper);
    }

    @Produces
    org.infinispan.protostream.MessageMarshaller typedValueMarshaller() {
        return new TypedVariableMarshaller(this.mapper);
    }
}

