/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.security.Permission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.AbstractPermissionCollection;
import org.wildfly.security.permission.PermissionUtil;
import org.wildfly.security.util.ArrayIterator;

public final class SimplePermissionCollection
extends AbstractPermissionCollection {
    private static final long serialVersionUID = -9157630531211570679L;
    private final AtomicReference<Permission[]> permissionsRef = new AtomicReference<Permission[]>(PermissionUtil.NO_PERMISSIONS);

    public SimplePermissionCollection(AbstractPermission<?> sourcePermission) {
        super(sourcePermission);
    }

    @Override
    public int size() {
        return this.permissionsRef.get().length;
    }

    @Override
    protected void doAdd(AbstractPermission<?> permission) {
        Permission[] newVal;
        Permission[] oldVal;
        AtomicReference<Permission[]> permissionsRef = this.permissionsRef;
        do {
            int count;
            Permission[] readVal = permissionsRef.get();
            do {
                count = 0;
                for (Permission test2 : oldVal = readVal) {
                    if (test2.implies(permission)) {
                        return;
                    }
                    if (permission.implies(test2)) continue;
                    ++count;
                }
            } while ((readVal = permissionsRef.get()) != oldVal);
            newVal = new Permission[count + 1];
            int i = 0;
            for (Permission test3 : oldVal) {
                if (permission.implies(test3)) continue;
                newVal[i++] = test3;
            }
            newVal[i] = permission;
        } while (!permissionsRef.compareAndSet(oldVal, newVal));
    }

    @Override
    public boolean implies(Permission permission) {
        for (Permission test2 : this.permissionsRef.get()) {
            if (!test2.implies(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Permission> iterator() {
        return new ArrayIterator<Permission>(this.permissionsRef.get());
    }

    @Override
    public Enumeration<Permission> elements() {
        return new ArrayIterator<Permission>(this.permissionsRef.get());
    }
}

