/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.api;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.models.MatchedExecutionHeaders;
import org.kie.kogito.trusty.service.responses.ExecutionsResponse;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.Execution;
import org.kie.kogito.trusty.storage.api.model.ExecutionType;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@QuarkusTest
class ExecutionsApiV1IT {
    private static final String MODEL_DEFINITION = "definition";
    @InjectMock
    TrustyService executionService;

    ExecutionsApiV1IT() {
    }

    @Test
    void givenRequestWithoutLimitAndOffsetParametersWhenExecutionEndpointIsCalledThenTheDefaultValuesAreCorrect() {
        Mockito.when((Object)this.executionService.getExecutionHeaders((OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), ((Integer)ArgumentMatchers.any(Integer.class)).intValue(), ((Integer)ArgumentMatchers.any(Integer.class)).intValue(), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new MatchedExecutionHeaders(new ArrayList(), 0));
        ExecutionsResponse response = (ExecutionsResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=2000-01-01T00:00:00Z&to=2021-01-01T00:00:00Z", new Object[0])).as(ExecutionsResponse.class);
        Assertions.assertEquals((int)100, (int)response.getLimit());
        Assertions.assertEquals((int)0, (int)response.getOffset());
        Assertions.assertEquals((int)0, (int)response.getHeaders().size());
    }

    @Test
    void givenARequestWithoutTimeRangeParametersWhenExecutionEndpointIsCalledThenTheDefaultValuesAreUsed() {
        Mockito.when((Object)this.executionService.getExecutionHeaders((OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), ((Integer)ArgumentMatchers.any(Integer.class)).intValue(), ((Integer)ArgumentMatchers.any(Integer.class)).intValue(), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new MatchedExecutionHeaders(new ArrayList(), 0));
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/executions", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/executions?from=2000-01-01", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/executions?to=2000-01-01", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/executions?from=2000-01-01T00:00:00Z", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/executions?to=2000-01-01T00:00:00Z", new Object[0])).then()).statusCode(200);
    }

    @Test
    void givenARequestWithoutTimeZoneInformationWhenExecutionEndpointIsCalledThenBadRequestIsReturned() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/executions?to=2000-01-01T00:00:00&from=2000-01-01T00:00:00Z", new Object[0])).then()).statusCode(400);
    }

    @Test
    void givenARequestWithInvalidPaginationParametersWhenExecutionEndpointIsCalledThenBadRequestIsReturned() {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/executions?from=2000-01-01T00:00:00Z&to=2021-01-01T00:00:00Z&offset=-1", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/executions?from=2000-01-01T00:00:00Z&to=2021-01-01T00:00:00Z&limit=-1", new Object[0])).then()).statusCode(400);
    }

    @Test
    void givenARequestWithMalformedTimeRangeWhenExecutionEndpointIsCalledThenBadRequestIsReturned() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=2000-13-01&to=2021-01-01T00:00:00Z", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=2000-01-01T00:00:00Z&to=2021-13-01", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=NotADate&to=2021-01-01T00:00:00Z", new Object[0])).then()).statusCode(400);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=2000-13-01T00:00:00Z&to=NotADate", new Object[0])).then()).statusCode(400);
    }

    @Test
    void givenARequestWhenExecutionEndpointIsCalledThenTheExecutionHeaderIsReturned() throws ParseException {
        Execution execution = new Execution("test1", "http://localhost:8081/model", Long.valueOf(OffsetDateTime.parse("2020-01-01T00:00:00Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME).toInstant().toEpochMilli()), Boolean.valueOf(true), "name", "model", "namespace", ExecutionType.DECISION);
        Mockito.when((Object)this.executionService.getExecutionHeaders((OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), ((Integer)ArgumentMatchers.any(Integer.class)).intValue(), ((Integer)ArgumentMatchers.any(Integer.class)).intValue(), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new MatchedExecutionHeaders(List.of(execution), 1));
        ExecutionsResponse response = (ExecutionsResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=2000-01-01T00:00:00Z&to=2021-01-01T00:00:00Z", new Object[0])).as(ExecutionsResponse.class);
        Assertions.assertEquals((int)1, (int)response.getHeaders().size());
    }

    @Test
    void givenMoreResultsThanQueryLimitThenPaginationIsCorrect() throws ParseException {
        List<Execution> executions = this.generateExecutions(15);
        this.mockGetExecutionHeaders(executions, 0, 10);
        this.mockGetExecutionHeaders(executions, 5, 10);
        this.mockGetExecutionHeaders(executions, 10, 10);
        ExecutionsResponse response = (ExecutionsResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=2000-01-01T00:00:00Z&to=2021-01-01T00:00:00Z&limit=10", new Object[0])).as(ExecutionsResponse.class);
        Assertions.assertEquals((int)10, (int)response.getHeaders().size());
        Assertions.assertEquals((int)15, (int)response.getTotal());
        Assertions.assertEquals((int)0, (int)response.getOffset());
        Assertions.assertEquals((int)10, (int)response.getLimit());
        response = (ExecutionsResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=2000-01-01T00:00:00Z&to=2021-01-01T00:00:00Z&limit=10&offset=5", new Object[0])).as(ExecutionsResponse.class);
        Assertions.assertEquals((int)10, (int)response.getHeaders().size());
        Assertions.assertEquals((int)15, (int)response.getTotal());
        Assertions.assertEquals((int)5, (int)response.getOffset());
        Assertions.assertEquals((int)10, (int)response.getLimit());
        response = (ExecutionsResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/executions?from=2000-01-01T00:00:00Z&to=2021-01-01T00:00:00Z&limit=10&offset=10", new Object[0])).as(ExecutionsResponse.class);
        Assertions.assertEquals((int)5, (int)response.getHeaders().size());
        Assertions.assertEquals((int)15, (int)response.getTotal());
        Assertions.assertEquals((int)10, (int)response.getOffset());
        Assertions.assertEquals((int)10, (int)response.getLimit());
    }

    @Test
    void givenARequestWithExistingModelWhenModelEndpointIsCalledThenTheModelIsReturned() {
        Decision decision = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)decision.getExecutedModelName()).thenReturn((Object)"name");
        Mockito.when((Object)decision.getExecutedModelNamespace()).thenReturn((Object)"namespace");
        Mockito.when((Object)this.executionService.getDecisionById(ArgumentMatchers.anyString())).thenReturn((Object)decision);
        Mockito.when((Object)this.executionService.getModelById("name:namespace")).thenReturn((Object)MODEL_DEFINITION);
        Response response = (Response)RestAssured.given().contentType(ContentType.TEXT).when().get("/executions/123/model", new Object[0]);
        String definition = response.getBody().print();
        Assertions.assertEquals((Object)MODEL_DEFINITION, (Object)definition);
    }

    @Test
    void givenARequestWithoutExistingDecisionWhenModelEndpointIsCalledThenBadRequestIsReturned() {
        Mockito.when((Object)this.executionService.getDecisionById(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new IllegalArgumentException("Execution does not exist.")});
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).when().get("/executions/123/model", new Object[0])).then()).statusCode(400);
    }

    @Test
    void givenARequestWithoutExistingModelWhenModelEndpointIsCalledThenBadRequestIsReturned() {
        Mockito.when((Object)this.executionService.getModelById(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new IllegalArgumentException("Model does not exist.")});
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).when().get("/executions/123/model", new Object[0])).then()).statusCode(400);
    }

    private List<Execution> generateExecutions(int size) {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        for (int i = 0; i < size; ++i) {
            executions.add(new Execution(String.format("test-%d", i), "test", Long.valueOf(OffsetDateTime.parse("2020-01-01T00:00:00Z", DateTimeFormatter.ISO_OFFSET_DATE_TIME).plusDays(i).toInstant().toEpochMilli()), Boolean.valueOf(true), "name", "model", "namespace", ExecutionType.DECISION));
        }
        return executions;
    }

    private void mockGetExecutionHeaders(List<Execution> executions, int offset, int limit) {
        Mockito.when((Object)this.executionService.getExecutionHeaders((OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), (OffsetDateTime)ArgumentMatchers.any(OffsetDateTime.class), ArgumentMatchers.eq((int)limit), ArgumentMatchers.eq((int)offset), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)new MatchedExecutionHeaders(executions.subList(offset, Math.min(offset + limit, executions.size())), executions.size()));
    }
}

