/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.api;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.log.ResponseLoggingFilter;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.api.ExplainabilityApiV1;
import org.kie.kogito.trusty.service.responses.FeatureImportanceResponse;
import org.kie.kogito.trusty.service.responses.SalienciesResponse;
import org.kie.kogito.trusty.service.responses.SaliencyResponse;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityStatus;
import org.kie.kogito.trusty.storage.api.model.FeatureImportance;
import org.kie.kogito.trusty.storage.api.model.Saliency;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testcontainers.shaded.org.apache.commons.lang.builder.CompareToBuilder;

@QuarkusTest
class ExplainabilityApiV1IT {
    private static final String TEST_EXECUTION_ID = "executionId";
    @InjectMock
    TrustyService executionService;

    ExplainabilityApiV1IT() {
    }

    @Test
    void testSalienciesWithExplainabilityResult() {
        this.mockServiceWithExplainabilityResult();
        SalienciesResponse response = (SalienciesResponse)((Response)RestAssured.given().filter((Filter)new ResponseLoggingFilter()).when().get("/executions/decisions/executionId/explanations/saliencies", new Object[0])).as(SalienciesResponse.class);
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.getSaliencies());
        Assertions.assertSame((Object)2, (Object)response.getSaliencies().size());
        List sortedSaliencies = response.getSaliencies().stream().sorted((s1, s2) -> new CompareToBuilder().append((Object)s1.getOutcomeName(), (Object)s2.getOutcomeName()).toComparison()).collect(Collectors.toList());
        Assertions.assertNotNull(sortedSaliencies.get(0));
        Assertions.assertEquals((Object)"Output1", (Object)((SaliencyResponse)sortedSaliencies.get(0)).getOutcomeName());
        Assertions.assertNotNull((Object)((SaliencyResponse)sortedSaliencies.get(0)).getFeatureImportance());
        Assertions.assertSame((Object)2, (Object)((SaliencyResponse)sortedSaliencies.get(0)).getFeatureImportance().size());
        Assertions.assertEquals((Object)"Feature1", (Object)((FeatureImportanceResponse)((SaliencyResponse)sortedSaliencies.get(0)).getFeatureImportance().get(0)).getFeatureName());
        Assertions.assertEquals((double)0.49384, (Double)((FeatureImportanceResponse)((SaliencyResponse)sortedSaliencies.get(0)).getFeatureImportance().get(0)).getFeatureScore());
        Assertions.assertEquals((Object)"Feature2", (Object)((FeatureImportanceResponse)((SaliencyResponse)sortedSaliencies.get(0)).getFeatureImportance().get(1)).getFeatureName());
        Assertions.assertEquals((double)-0.1084, (Double)((FeatureImportanceResponse)((SaliencyResponse)sortedSaliencies.get(0)).getFeatureImportance().get(1)).getFeatureScore());
        Assertions.assertNotNull(sortedSaliencies.get(1));
        Assertions.assertEquals((Object)"Output2", (Object)((SaliencyResponse)sortedSaliencies.get(1)).getOutcomeName());
        Assertions.assertNotNull((Object)((SaliencyResponse)sortedSaliencies.get(1)).getFeatureImportance());
        Assertions.assertSame((Object)2, (Object)((SaliencyResponse)sortedSaliencies.get(1)).getFeatureImportance().size());
        Assertions.assertEquals((Object)"Feature1", (Object)((FeatureImportanceResponse)((SaliencyResponse)sortedSaliencies.get(1)).getFeatureImportance().get(0)).getFeatureName());
        Assertions.assertEquals((double)0.0, (Double)((FeatureImportanceResponse)((SaliencyResponse)sortedSaliencies.get(1)).getFeatureImportance().get(0)).getFeatureScore());
        Assertions.assertEquals((Object)"Feature2", (Object)((FeatureImportanceResponse)((SaliencyResponse)sortedSaliencies.get(1)).getFeatureImportance().get(1)).getFeatureName());
        Assertions.assertEquals((double)0.70293, (Double)((FeatureImportanceResponse)((SaliencyResponse)sortedSaliencies.get(1)).getFeatureImportance().get(1)).getFeatureScore());
    }

    @Test
    void testSalienciesWithNullExplainabilityResult() {
        this.mockServiceWithNullExplainabilityResult();
        ((ValidatableResponse)((Response)RestAssured.given().filter((Filter)new ResponseLoggingFilter()).when().get("/executions/decisions/executionId/explanations/saliencies", new Object[0])).then()).statusCode(400);
    }

    @Test
    void testSalienciesWithoutExplainabilityResult() {
        this.mockServiceWithoutExplainabilityResult();
        ((ValidatableResponse)((Response)RestAssured.given().filter((Filter)new ResponseLoggingFilter()).when().get("/executions/decisions/executionId/explanations/saliencies", new Object[0])).then()).statusCode(400);
    }

    @Test
    void testConverterMethodsNotThrowingWithNullModelValues() {
        Assertions.assertDoesNotThrow(() -> ExplainabilityApiV1.explainabilityResultModelToResponse(null));
        Assertions.assertDoesNotThrow(() -> ExplainabilityApiV1.featureImportanceModelToResponse(null));
        Assertions.assertDoesNotThrow(() -> ExplainabilityApiV1.saliencyModelToResponse(null));
    }

    private void mockServiceWithExplainabilityResult() {
        Mockito.when((Object)this.executionService.getExplainabilityResultById((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID))).thenReturn((Object)ExplainabilityApiV1IT.buildValidExplainabilityResult());
    }

    private void mockServiceWithNullExplainabilityResult() {
        Mockito.when((Object)this.executionService.getExplainabilityResultById(ArgumentMatchers.anyString())).thenReturn(null);
    }

    private void mockServiceWithoutExplainabilityResult() {
        Mockito.when((Object)this.executionService.getExplainabilityResultById(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new IllegalArgumentException("Explainability result does not exist.")});
    }

    private static ExplainabilityResult buildValidExplainabilityResult() {
        return new ExplainabilityResult(TEST_EXECUTION_ID, ExplainabilityStatus.SUCCEEDED, null, List.of(new Saliency("O1", "Output1", List.of(new FeatureImportance("Feature1", Double.valueOf(0.49384)), new FeatureImportance("Feature2", Double.valueOf(-0.1084)))), new Saliency("O2", "Output2", List.of(new FeatureImportance("Feature1", Double.valueOf(0.0)), new FeatureImportance("Feature2", Double.valueOf(0.70293))))));
    }
}

