/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import io.cloudevents.CloudEvent;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.kie.kogito.trusty.service.messaging.incoming.ExplainabilityResultConsumer;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.FeatureImportance;
import org.kie.kogito.trusty.storage.api.model.Saliency;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testcontainers.shaded.org.apache.commons.lang.builder.CompareToBuilder;

class ExplainabilityResultConsumerTest {
    private static final String TEST_EXECUTION_ID = "test";
    private static final String TEST_FEATURE_1_ID = "f1-id";
    private static final String TEST_FEATURE_1_NAME = "feature1";
    private static final String TEST_FEATURE_2_ID = "f2-id";
    private static final String TEST_FEATURE_2_NAME = "feature2";
    private static final String TEST_OUTCOME_1_ID = "o1-id";
    private static final String TEST_OUTCOME_1_NAME = "outcome1";
    private static final Decision TEST_DECISION = new Decision("test", null, null, Boolean.valueOf(true), null, null, null, List.of(new DecisionInput("f1-id", "feature1", null), new DecisionInput("f2-id", "feature2", null)), List.of(new DecisionOutcome("o1-id", "outcome1", null, null, null, null)));
    private static final FeatureImportanceDto TEST_FEATURE_IMPORTANCE_DTO_1 = new FeatureImportanceDto("feature1", Double.valueOf(1.0));
    private static final FeatureImportanceDto TEST_FEATURE_IMPORTANCE_DTO_2 = new FeatureImportanceDto("feature2", Double.valueOf(-1.0));
    private static final SaliencyDto TEST_SALIENCY_DTO = new SaliencyDto(Arrays.asList(TEST_FEATURE_IMPORTANCE_DTO_1, TEST_FEATURE_IMPORTANCE_DTO_2));
    private static final ExplainabilityResultDto TEST_RESULT_DTO = ExplainabilityResultDto.buildSucceeded((String)"test", Collections.singletonMap("outcome1", TEST_SALIENCY_DTO));
    private TrustyService trustyService;
    private ExplainabilityResultConsumer consumer;

    ExplainabilityResultConsumerTest() {
    }

    @BeforeEach
    void setup() {
        this.trustyService = (TrustyService)Mockito.mock(TrustyService.class);
        this.consumer = new ExplainabilityResultConsumer(this.trustyService, TrustyServiceTestUtils.MAPPER);
    }

    @Test
    void testCorrectCloudEvent() {
        Message<String> message = this.mockMessage(ExplainabilityResultConsumerTest.buildCloudEventJsonString(ExplainabilityResultDto.buildSucceeded((String)TEST_EXECUTION_ID, Collections.emptyMap())));
        ((TrustyService)Mockito.doNothing().when((Object)this.trustyService)).storeExplainabilityResult((String)ArgumentMatchers.any(String.class), (ExplainabilityResult)ArgumentMatchers.any(ExplainabilityResult.class));
        this.testNumberOfInvocations(message, 1);
    }

    @Test
    void testInvalidPayload() {
        Message<String> message = this.mockMessage("Not a cloud event");
        this.testNumberOfInvocations(message, 0);
    }

    @Test
    void testExceptionsAreCatched() {
        Message<String> message = this.mockMessage(ExplainabilityResultConsumerTest.buildCloudEventJsonString(ExplainabilityResultDto.buildSucceeded((String)TEST_EXECUTION_ID, Collections.emptyMap())));
        ((TrustyService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Something really bad")}).when((Object)this.trustyService)).storeExplainabilityResult((String)ArgumentMatchers.any(String.class), (ExplainabilityResult)ArgumentMatchers.any(ExplainabilityResult.class));
        Assertions.assertDoesNotThrow(() -> this.consumer.handleMessage(message));
    }

    private void testExplainabilityResultFromWith(Decision decision, String expectedOutcomeId) {
        ExplainabilityResult explainabilityResult = ExplainabilityResultConsumer.explainabilityResultFrom((ExplainabilityResultDto)TEST_RESULT_DTO, (Decision)decision);
        Assertions.assertNotNull((Object)explainabilityResult);
        Assertions.assertEquals((Object)TEST_RESULT_DTO.getExecutionId(), (Object)explainabilityResult.getExecutionId());
        Assertions.assertNotNull((Object)TEST_RESULT_DTO.getSaliencies());
        Assertions.assertEquals((int)TEST_RESULT_DTO.getSaliencies().size(), (int)explainabilityResult.getSaliencies().size());
        Optional<Saliency> optSaliency = explainabilityResult.getSaliencies().stream().filter(s -> s.getOutcomeName().equals(TEST_OUTCOME_1_NAME)).findFirst();
        Assertions.assertFalse((boolean)optSaliency.isEmpty());
        Saliency saliency = optSaliency.get();
        Assertions.assertEquals((Object)expectedOutcomeId, (Object)saliency.getOutcomeId());
        Assertions.assertNotNull((Object)saliency.getFeatureImportance());
        Assertions.assertEquals((int)TEST_SALIENCY_DTO.getFeatureImportance().size(), (int)saliency.getFeatureImportance().size());
        List featureImportances = saliency.getFeatureImportance().stream().sorted(ExplainabilityResultConsumerTest::compareFeatureImportance).collect(Collectors.toList());
        FeatureImportanceDto expected0 = (FeatureImportanceDto)TEST_SALIENCY_DTO.getFeatureImportance().get(0);
        FeatureImportance actual0 = (FeatureImportance)featureImportances.get(0);
        Assertions.assertEquals((Object)expected0.getFeatureName(), (Object)actual0.getFeatureName());
        Assertions.assertEquals((Double)expected0.getScore(), (Double)actual0.getScore());
        FeatureImportanceDto expected1 = (FeatureImportanceDto)TEST_SALIENCY_DTO.getFeatureImportance().get(1);
        FeatureImportance actual1 = (FeatureImportance)featureImportances.get(1);
        Assertions.assertEquals((Object)expected1.getFeatureName(), (Object)actual1.getFeatureName());
        Assertions.assertEquals((Double)expected1.getScore(), (Double)actual1.getScore());
    }

    @Test
    void testExplainabilityResultFromWithValidParams() {
        this.testExplainabilityResultFromWith(TEST_DECISION, TEST_OUTCOME_1_ID);
    }

    @Test
    void testExplainabilityResultFromWithNullDecision() {
        this.testExplainabilityResultFromWith(null, null);
    }

    @Test
    void testExplainabilityResultFromWithNullDto() {
        Assertions.assertNull((Object)ExplainabilityResultConsumer.explainabilityResultFrom(null, null));
    }

    @Test
    void testFeatureImportanceFromWithValidParams() {
        FeatureImportance featureImportance = ExplainabilityResultConsumer.featureImportanceFrom((FeatureImportanceDto)TEST_FEATURE_IMPORTANCE_DTO_1);
        Assertions.assertNotNull((Object)featureImportance);
        Assertions.assertEquals((Object)TEST_FEATURE_IMPORTANCE_DTO_1.getFeatureName(), (Object)featureImportance.getFeatureName());
        Assertions.assertEquals((Double)TEST_FEATURE_IMPORTANCE_DTO_1.getScore(), (Double)featureImportance.getScore());
    }

    @Test
    void testFeatureImportanceFromWithNullDto() {
        Assertions.assertNull((Object)ExplainabilityResultConsumer.featureImportanceFrom(null));
    }

    @Test
    void testSaliencyFromWithValidParams() {
        Saliency saliency = ExplainabilityResultConsumer.saliencyFrom((String)TEST_OUTCOME_1_ID, (String)TEST_OUTCOME_1_NAME, (SaliencyDto)TEST_SALIENCY_DTO);
        Assertions.assertNotNull((Object)saliency);
        Assertions.assertEquals((int)TEST_SALIENCY_DTO.getFeatureImportance().size(), (int)saliency.getFeatureImportance().size());
        Assertions.assertEquals((Object)((FeatureImportanceDto)TEST_SALIENCY_DTO.getFeatureImportance().get(0)).getFeatureName(), (Object)((FeatureImportance)saliency.getFeatureImportance().get(0)).getFeatureName());
        Assertions.assertEquals((double)((FeatureImportanceDto)TEST_SALIENCY_DTO.getFeatureImportance().get(0)).getScore(), (double)((FeatureImportance)saliency.getFeatureImportance().get(0)).getScore(), (double)0.1);
    }

    @Test
    void testSaliencyFromWithNullDto() {
        Assertions.assertNull((Object)ExplainabilityResultConsumer.saliencyFrom(null, null, null));
    }

    private Message<String> mockMessage(String payload) {
        Message message = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)((String)message.getPayload())).thenReturn((Object)payload);
        return message;
    }

    private void testNumberOfInvocations(Message<String> message, int wantedNumberOfServiceInvocations) {
        this.consumer.handleMessage(message);
        ((TrustyService)Mockito.verify((Object)this.trustyService, (VerificationMode)Mockito.times((int)wantedNumberOfServiceInvocations))).storeExplainabilityResult((String)ArgumentMatchers.any(), (ExplainabilityResult)ArgumentMatchers.any());
        ((Message)Mockito.verify(message, (VerificationMode)Mockito.times((int)1))).ack();
    }

    public static CloudEvent buildExplainabilityCloudEvent(ExplainabilityResultDto resultDto) {
        return (CloudEvent)CloudEventUtils.build((String)resultDto.getExecutionId(), (URI)URI.create("explainabilityResult/test"), (Object)resultDto, ExplainabilityResultDto.class).get();
    }

    public static String buildCloudEventJsonString(ExplainabilityResultDto resultDto) {
        return (String)CloudEventUtils.encode((CloudEvent)ExplainabilityResultConsumerTest.buildExplainabilityCloudEvent(resultDto)).orElseThrow(IllegalStateException::new);
    }

    private static int compareFeatureImportance(FeatureImportance expected, FeatureImportance actual) {
        return new CompareToBuilder().append((Object)expected.getFeatureName(), (Object)actual.getFeatureName()).toComparison();
    }
}

