/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Test;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@QuarkusTest
@QuarkusTestResource(value=KafkaQuarkusTestResource.class)
public class ModelEventConsumerIT {
    @ConfigProperty(name="kafka.bootstrap.servers")
    String kafkaBootstrapServers;
    @InjectMock
    TrustyService trustyService;
    KafkaClient kafkaClient;

    @Test
    public void eventLoopIsNotStoppedWithException() {
        this.kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
        ((TrustyService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Something really bad")}).when((Object)this.trustyService)).storeModel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        this.kafkaClient.produce(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildCorrectModelEvent()), "kogito-tracing-model-test");
        this.kafkaClient.produce(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildCorrectModelEvent()), "kogito-tracing-model-test");
        ((TrustyService)Mockito.verify((Object)this.trustyService, (VerificationMode)Mockito.timeout((long)3000L).times(2))).storeModel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }
}

