/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.kogito.tracing.decision.event.message.Message;
import org.kie.kogito.tracing.decision.event.message.MessageCategory;
import org.kie.kogito.tracing.decision.event.message.MessageLevel;
import org.kie.kogito.tracing.decision.event.trace.TraceEvent;
import org.kie.kogito.tracing.decision.event.trace.TraceOutputValue;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.kie.kogito.trusty.service.messaging.incoming.TraceEventConverter;
import org.kie.kogito.trusty.service.messaging.incoming.TraceEventTestUtils;
import org.kie.kogito.trusty.storage.api.model.Decision;

class TraceEventConverterTest {
    TraceEventConverterTest() {
    }

    private static void doTest(TraceEvent traceEvent, Decision expectedDecision) {
        Decision actualDecision = TraceEventConverter.toDecision((TraceEvent)traceEvent, (String)"http://localhost:8080/Traffic+Violation");
        TraceEventTestUtils.assertDecision(expectedDecision, actualDecision);
    }

    @Test
    void testCorrectTraceEvent() {
        TraceEventConverterTest.doTest(TrustyServiceTestUtils.buildCorrectTraceEvent("82639415-ceb1-411a-b3c8-4832e6a82905"), TrustyServiceTestUtils.buildCorrectDecision("82639415-ceb1-411a-b3c8-4832e6a82905"));
    }

    @Test
    void testTraceEventWithError() {
        TraceEventConverterTest.doTest(TrustyServiceTestUtils.buildTraceEventWithErrors(), TrustyServiceTestUtils.buildDecisionWithErrors());
    }

    @Test
    void testTraceEventWithNullFields() {
        TraceEventConverterTest.doTest(TrustyServiceTestUtils.buildTraceEventWithNullFields(), TrustyServiceTestUtils.buildDecisionWithNullFields());
    }

    @Test
    void testDecisionHasSucceeded() {
        Assertions.assertFalse((boolean)TraceEventConverter.decisionHasSucceeded(null), (String)"Decision must be failed if input list is null");
        Assertions.assertTrue((boolean)TraceEventConverter.decisionHasSucceeded(Collections.emptyList()), (String)"Decision must be succeeeded if input list is empty");
        Assertions.assertTrue((boolean)TraceEventConverter.decisionHasSucceeded(List.of(TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, false), TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.SKIPPED, false), TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED, false))), (String)"Decision must be succeeded if there are no outputs with 'FAILED' status or containing error messages");
        Assertions.assertFalse((boolean)TraceEventConverter.decisionHasSucceeded(List.of(TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, false), TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.FAILED, false))), (String)"Decision must be failed if at least one output has 'FAILED' status");
        Assertions.assertFalse((boolean)TraceEventConverter.decisionHasSucceeded(List.of(TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, false), TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.SKIPPED, true))), (String)"Decision must be failed if at least one output contains error messages");
        Assertions.assertFalse((boolean)TraceEventConverter.decisionHasSucceeded(List.of(TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, false), TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED, true))), (String)"Decision must be failed if at least one output contains error messages");
        Assertions.assertFalse((boolean)TraceEventConverter.decisionHasSucceeded(List.of(TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.SKIPPED, true), TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.FAILED, false))), (String)"Decision must be failed if at least one output has 'FAILED' status or contains error messages");
        Assertions.assertFalse((boolean)TraceEventConverter.decisionHasSucceeded(List.of(TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.NOT_EVALUATED, true), TraceEventConverterTest.buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus.FAILED, true))), (String)"Decision must be failed if at least one output has 'FAILED' status or contains error messages");
    }

    private static TraceOutputValue buildTraceOutputValue(DMNDecisionResult.DecisionEvaluationStatus status, boolean withErrorMessage) {
        String id = UUID.randomUUID().toString();
        List messages = withErrorMessage ? List.of(new Message(MessageLevel.ERROR, MessageCategory.INTERNAL, "TEST", id, "Error message", null, null)) : Collections.emptyList();
        return new TraceOutputValue(id, "Output", status.name(), null, null, messages);
    }
}

