/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.mocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.ws.rs.NotFoundException;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;

public class StorageImplMock<K, V>
implements Storage<K, V> {
    private Map<K, V> storage = new HashMap();
    private List<Consumer<V>> createdListeners = new ArrayList<Consumer<V>>();
    private List<Consumer<V>> updateListeners = new ArrayList<Consumer<V>>();
    private List<Consumer<K>> removedListeners = new ArrayList<Consumer<K>>();
    private Class<K> rootType;

    public StorageImplMock(Class<K> type) {
        this.rootType = type;
    }

    public void addObjectCreatedListener(Consumer<V> consumer) {
        this.createdListeners.add(consumer);
    }

    public void addObjectUpdatedListener(Consumer<V> consumer) {
        this.updateListeners.add(consumer);
    }

    public void addObjectRemovedListener(Consumer<K> consumer) {
        this.removedListeners.add(consumer);
    }

    public Query<V> query() {
        throw new RuntimeException("This mock does not provide query support.");
    }

    public V get(K key) {
        if (this.storage.containsKey(key)) {
            return this.storage.get(key);
        }
        throw new NotFoundException("Element not found");
    }

    public V put(K key, V value) {
        this.createdListeners.forEach(x -> x.accept(value));
        this.storage.put(key, value);
        return value;
    }

    public V remove(K key) {
        this.removedListeners.forEach(x -> x.accept(key));
        V element = this.storage.get(key);
        this.storage.remove(key);
        return element;
    }

    public boolean containsKey(K key) {
        return this.storage.containsKey(key);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.storage.entrySet();
    }

    public void clear() {
        this.storage = new HashMap();
    }

    public String getRootType() {
        return this.rootType.getName();
    }
}

