/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.responses;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.kie.kogito.trusty.service.responses.ResponseUtils;
import org.kie.kogito.trusty.service.responses.TypedVariableResponse;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;

class TypedVariableResponseTest {
    private static final String FIELD_COMPONENTS = "components";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE_REF = "typeRef";
    private static final String FIELD_VALUE = "value";
    private static final String TYPE_REF_NUMBER = "number";
    private static final String TYPE_REF_STRING = "string";
    private static final String TYPE_REF_STRUCT = "StructType";
    private static final String VAR_NAME_COLLECTION = "tstCollection";
    private static final String VAR_NAME_STRUCT = "tstStruct";
    private static final String VAR_NAME_UNIT = "tstUnit";
    private static final String VALUE_AGE = "age";
    private static final String VALUE_COUNT_ONE = "One";
    private static final String VALUE_COUNT_TWO = "Two";
    private static final String VALUE_COUNT_THREE = "Three";
    private static final String VALUE_HELLO_THIS_IS_A_TEST = "hello this is a test";
    private static final String VALUE_MILANO = "Milano";
    private static final String VALUE_MONZA = "Monza";
    private static final String VALUE_TAVULLIA = "Tavullia";
    private static final String VALUE_TOWN = "town";
    private static final int VALUE_34 = 34;
    private static final int VALUE_41 = 41;
    private static final int VALUE_50 = 50;

    TypedVariableResponseTest() {
    }

    @Test
    void testCollection() throws JsonProcessingException {
        TypedVariableResponse response = ResponseUtils.typedVariableResponseFrom((TypedVariable)TypedVariableResponseTest.buildTestCollection());
        Assertions.assertEquals((Object)VAR_NAME_COLLECTION, (Object)response.getName());
        Assertions.assertEquals((Object)TYPE_REF_STRING, (Object)response.getTypeRef());
        Assertions.assertNotNull((Object)response.getValue());
        Assertions.assertNull((Object)response.getComponents());
        Assertions.assertTrue((boolean)response.getValue().isArray());
        Assertions.assertSame((Object)3, (Object)response.getValue().size());
        Assertions.assertTrue((boolean)response.getValue().get(0).isTextual());
        Assertions.assertEquals((Object)VALUE_COUNT_ONE, (Object)response.getValue().get(0).textValue());
        Assertions.assertTrue((boolean)response.getValue().get(1).isTextual());
        Assertions.assertEquals((Object)VALUE_COUNT_TWO, (Object)response.getValue().get(1).textValue());
        Assertions.assertTrue((boolean)response.getValue().get(2).isTextual());
        Assertions.assertEquals((Object)VALUE_COUNT_THREE, (Object)response.getValue().get(2).textValue());
    }

    @Test
    void testCollectionOfStructures() throws JsonProcessingException {
        TypedVariableResponse response = ResponseUtils.typedVariableResponseFrom((TypedVariable)TypedVariableResponseTest.buildTestCollectionOfStructures());
        Assertions.assertEquals((Object)VAR_NAME_COLLECTION, (Object)response.getName());
        Assertions.assertEquals((Object)TYPE_REF_STRUCT, (Object)response.getTypeRef());
        Assertions.assertNull((Object)response.getValue());
        Assertions.assertNotNull((Object)response.getComponents());
        Assertions.assertSame((Object)2, (Object)response.getComponents().size());
        JsonNode firstComponent = (JsonNode)response.getComponents().get(0);
        Assertions.assertTrue((boolean)firstComponent.isArray());
        Assertions.assertSame((Object)2, (Object)firstComponent.size());
        Assertions.assertTrue((boolean)firstComponent.get(0).isObject());
        Assertions.assertTrue((boolean)firstComponent.get(0).get(FIELD_NAME).isTextual());
        Assertions.assertEquals((Object)VALUE_AGE, (Object)firstComponent.get(0).get(FIELD_NAME).textValue());
        Assertions.assertTrue((boolean)firstComponent.get(0).get(FIELD_TYPE_REF).isTextual());
        Assertions.assertEquals((Object)TYPE_REF_NUMBER, (Object)firstComponent.get(0).get(FIELD_TYPE_REF).textValue());
        Assertions.assertTrue((boolean)firstComponent.get(0).get(FIELD_VALUE).isInt());
        Assertions.assertSame((Object)34, (Object)firstComponent.get(0).get(FIELD_VALUE).intValue());
        Assertions.assertTrue((boolean)firstComponent.get(0).get(FIELD_COMPONENTS).isNull());
        Assertions.assertTrue((boolean)firstComponent.get(1).isObject());
        Assertions.assertTrue((boolean)firstComponent.get(1).get(FIELD_NAME).isTextual());
        Assertions.assertEquals((Object)VALUE_TOWN, (Object)firstComponent.get(1).get(FIELD_NAME).textValue());
        Assertions.assertTrue((boolean)firstComponent.get(1).get(FIELD_TYPE_REF).isTextual());
        Assertions.assertEquals((Object)TYPE_REF_STRING, (Object)firstComponent.get(1).get(FIELD_TYPE_REF).textValue());
        Assertions.assertTrue((boolean)firstComponent.get(1).get(FIELD_VALUE).isTextual());
        Assertions.assertEquals((Object)VALUE_MONZA, (Object)firstComponent.get(1).get(FIELD_VALUE).textValue());
        Assertions.assertTrue((boolean)firstComponent.get(1).get(FIELD_COMPONENTS).isNull());
        JsonNode secondComponent = (JsonNode)response.getComponents().get(1);
        Assertions.assertTrue((boolean)secondComponent.isArray());
        Assertions.assertSame((Object)2, (Object)secondComponent.size());
        Assertions.assertTrue((boolean)secondComponent.get(0).isObject());
        Assertions.assertTrue((boolean)secondComponent.get(0).get(FIELD_NAME).isTextual());
        Assertions.assertEquals((Object)VALUE_AGE, (Object)secondComponent.get(0).get(FIELD_NAME).textValue());
        Assertions.assertTrue((boolean)secondComponent.get(0).get(FIELD_TYPE_REF).isTextual());
        Assertions.assertEquals((Object)TYPE_REF_NUMBER, (Object)secondComponent.get(0).get(FIELD_TYPE_REF).textValue());
        Assertions.assertTrue((boolean)secondComponent.get(0).get(FIELD_VALUE).isInt());
        Assertions.assertSame((Object)41, (Object)secondComponent.get(0).get(FIELD_VALUE).intValue());
        Assertions.assertTrue((boolean)secondComponent.get(0).get(FIELD_COMPONENTS).isNull());
        Assertions.assertTrue((boolean)secondComponent.get(1).isObject());
        Assertions.assertTrue((boolean)secondComponent.get(1).get(FIELD_NAME).isTextual());
        Assertions.assertEquals((Object)VALUE_TOWN, (Object)secondComponent.get(1).get(FIELD_NAME).textValue());
        Assertions.assertTrue((boolean)secondComponent.get(1).get(FIELD_TYPE_REF).isTextual());
        Assertions.assertEquals((Object)TYPE_REF_STRING, (Object)secondComponent.get(1).get(FIELD_TYPE_REF).textValue());
        Assertions.assertTrue((boolean)secondComponent.get(1).get(FIELD_VALUE).isTextual());
        Assertions.assertEquals((Object)VALUE_TAVULLIA, (Object)secondComponent.get(1).get(FIELD_VALUE).textValue());
        Assertions.assertTrue((boolean)secondComponent.get(1).get(FIELD_COMPONENTS).isNull());
    }

    @Test
    void testStructure() throws JsonProcessingException {
        TypedVariableResponse response = ResponseUtils.typedVariableResponseFrom((TypedVariable)TypedVariableResponseTest.buildTestStructure());
        Assertions.assertEquals((Object)VAR_NAME_STRUCT, (Object)response.getName());
        Assertions.assertEquals((Object)TYPE_REF_STRUCT, (Object)response.getTypeRef());
        Assertions.assertNull((Object)response.getValue());
        Assertions.assertNotNull((Object)response.getComponents());
        Assertions.assertSame((Object)2, (Object)response.getComponents().size());
        JsonNode firstComponent = (JsonNode)response.getComponents().get(0);
        Assertions.assertTrue((boolean)firstComponent.isObject());
        Assertions.assertTrue((boolean)firstComponent.get(FIELD_NAME).isTextual());
        Assertions.assertEquals((Object)VALUE_AGE, (Object)firstComponent.get(FIELD_NAME).textValue());
        Assertions.assertTrue((boolean)firstComponent.get(FIELD_TYPE_REF).isTextual());
        Assertions.assertEquals((Object)TYPE_REF_NUMBER, (Object)firstComponent.get(FIELD_TYPE_REF).textValue());
        Assertions.assertTrue((boolean)firstComponent.get(FIELD_VALUE).isInt());
        Assertions.assertSame((Object)50, (Object)firstComponent.get(FIELD_VALUE).intValue());
        Assertions.assertTrue((boolean)firstComponent.get(FIELD_COMPONENTS).isNull());
        JsonNode secondComponent = (JsonNode)response.getComponents().get(1);
        Assertions.assertTrue((boolean)secondComponent.isObject());
        Assertions.assertTrue((boolean)secondComponent.get(FIELD_NAME).isTextual());
        Assertions.assertEquals((Object)VALUE_TOWN, (Object)secondComponent.get(FIELD_NAME).textValue());
        Assertions.assertTrue((boolean)secondComponent.get(FIELD_TYPE_REF).isTextual());
        Assertions.assertEquals((Object)TYPE_REF_STRING, (Object)secondComponent.get(FIELD_TYPE_REF).textValue());
        Assertions.assertTrue((boolean)secondComponent.get(FIELD_VALUE).isTextual());
        Assertions.assertEquals((Object)VALUE_MILANO, (Object)secondComponent.get(FIELD_VALUE).textValue());
        Assertions.assertTrue((boolean)secondComponent.get(FIELD_COMPONENTS).isNull());
    }

    @Test
    void testUnit() throws JsonProcessingException {
        TypedVariableResponse response = ResponseUtils.typedVariableResponseFrom((TypedVariable)TypedVariableResponseTest.buildTestUnitVariable());
        Assertions.assertEquals((Object)VAR_NAME_UNIT, (Object)response.getName());
        Assertions.assertEquals((Object)TYPE_REF_STRING, (Object)response.getTypeRef());
        Assertions.assertNotNull((Object)response.getValue());
        Assertions.assertNull((Object)response.getComponents());
        Assertions.assertTrue((boolean)response.getValue().isTextual());
        Assertions.assertEquals((Object)VALUE_HELLO_THIS_IS_A_TEST, (Object)response.getValue().textValue());
    }

    private static TypedVariable buildTestCollection() throws JsonProcessingException {
        return TypedVariable.buildCollection((String)VAR_NAME_COLLECTION, (String)TYPE_REF_STRING, List.of(TypedVariableResponseTest.buildTestUnitVariable(null, TYPE_REF_STRING, "\"One\""), TypedVariableResponseTest.buildTestUnitVariable(null, TYPE_REF_STRING, "\"Two\""), TypedVariableResponseTest.buildTestUnitVariable(null, TYPE_REF_STRING, "\"Three\"")));
    }

    private static TypedVariable buildTestCollectionOfStructures() throws JsonProcessingException {
        return TypedVariable.buildCollection((String)VAR_NAME_COLLECTION, (String)TYPE_REF_STRUCT, List.of(TypedVariable.buildStructure(null, (String)TYPE_REF_STRUCT, List.of(TypedVariableResponseTest.buildTestUnitVariable(VALUE_AGE, TYPE_REF_NUMBER, "34"), TypedVariableResponseTest.buildTestUnitVariable(VALUE_TOWN, TYPE_REF_STRING, "\"Monza\""))), TypedVariable.buildStructure(null, (String)TYPE_REF_STRUCT, List.of(TypedVariableResponseTest.buildTestUnitVariable(VALUE_AGE, TYPE_REF_NUMBER, "41"), TypedVariableResponseTest.buildTestUnitVariable(VALUE_TOWN, TYPE_REF_STRING, "\"Tavullia\"")))));
    }

    private static TypedVariable buildTestStructure() throws JsonProcessingException {
        return TypedVariable.buildStructure((String)VAR_NAME_STRUCT, (String)TYPE_REF_STRUCT, List.of(TypedVariableResponseTest.buildTestUnitVariable(VALUE_AGE, TYPE_REF_NUMBER, "50"), TypedVariableResponseTest.buildTestUnitVariable(VALUE_TOWN, TYPE_REF_STRING, "\"Milano\"")));
    }

    private static TypedVariable buildTestUnitVariable() throws JsonProcessingException {
        return TypedVariableResponseTest.buildTestUnitVariable(VAR_NAME_UNIT, TYPE_REF_STRING, "\"hello this is a test\"");
    }

    private static TypedVariable buildTestUnitVariable(String name, String typeRef, String jsonValue) throws JsonProcessingException {
        return TypedVariable.buildUnit((String)name, (String)typeRef, (JsonNode)TrustyServiceTestUtils.MAPPER.readTree(jsonValue));
    }
}

