/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.decision.DecisionModelType;
import org.kie.kogito.tracing.decision.event.model.ModelEvent;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.service.messaging.incoming.ModelEventConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ModelEventConsumer
extends BaseEventConsumer<ModelEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelEventConsumer.class);
    private static final TypeReference<ModelEvent> CLOUD_EVENT_TYPE = new TypeReference<ModelEvent>(){};

    private ModelEventConsumer() {
    }

    @Inject
    public ModelEventConsumer(TrustyService service, ObjectMapper mapper) {
        super(service, mapper);
    }

    @Override
    @Incoming(value="kogito-tracing-model")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected TypeReference<ModelEvent> getEventType() {
        return CLOUD_EVENT_TYPE;
    }

    @Override
    protected void internalHandleCloudEvent(CloudEvent cloudEvent, ModelEvent payload) {
        DecisionModelType modelEventType = payload.getType();
        if (modelEventType == DecisionModelType.DMN) {
            this.service.storeModel(payload.getGav().getGroupId(), payload.getGav().getArtifactId(), payload.getGav().getVersion(), payload.getName(), payload.getNamespace(), ModelEventConverter.toModel(payload));
        } else {
            LOG.error("Unsupported DecisionModelType type {}", (Object)modelEventType);
        }
    }
}

