/*
 *  Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.kie.kogito.trusty.service.messaging.incoming;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Test;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.kie.kogito.trusty.service.TrustyService;

import static org.kie.kogito.trusty.service.TrustyServiceTestUtils.buildCloudEventJsonString;
import static org.kie.kogito.trusty.service.TrustyServiceTestUtils.buildCorrectModelEvent;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.timeout;
import static org.mockito.Mockito.verify;

@QuarkusTest
@QuarkusTestResource(KafkaQuarkusTestResource.class)
public class ModelEventConsumerIT {

    @ConfigProperty(name = KafkaQuarkusTestResource.KOGITO_KAFKA_PROPERTY)
    String kafkaBootstrapServers;

    @InjectMock
    TrustyService trustyService;

    KafkaClient kafkaClient;

    @Test
    public void eventLoopIsNotStoppedWithException() {
        kafkaClient = new KafkaClient(kafkaBootstrapServers);

        doThrow(new RuntimeException("Something really bad"))
                .when(trustyService)
                .storeModel(anyString(), anyString(), anyString(), anyString(), anyString(), anyString());

        kafkaClient.produce(buildCloudEventJsonString(buildCorrectModelEvent()),
                            KafkaConstants.KOGITO_TRACING_MODEL_TOPIC);
        kafkaClient.produce(buildCloudEventJsonString(buildCorrectModelEvent()),
                            KafkaConstants.KOGITO_TRACING_MODEL_TOPIC);

        verify(trustyService, timeout(3000).times(2))
                .storeModel(anyString(), anyString(), anyString(), anyString(), anyString(), anyString());
    }
}
