/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;
import org.kie.kogito.trusty.service.messaging.MessagingUtils;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;

class MessagingUtilsTest {
    TypedVariable typedVariable = new TypedVariable(TypedValue.Kind.UNIT, "name", "string", (JsonNode)new TextNode("sample"), Collections.emptyList());

    MessagingUtilsTest() {
    }

    @Test
    void modelToTracingTypedValue() {
        Assertions.assertNull((Object)MessagingUtils.modelToTracingTypedValue(null));
        TypedValue typedValue = MessagingUtils.modelToTracingTypedValue((TypedVariable)this.typedVariable);
        Assertions.assertNotNull((Object)typedValue);
        Assertions.assertTrue((boolean)(typedValue instanceof UnitValue));
    }

    @Test
    void modelToTracingTypedValueCollection() {
        Assertions.assertNull((Object)MessagingUtils.modelToTracingTypedValueCollection(null));
        Collection typedValues = MessagingUtils.modelToTracingTypedValueCollection(Collections.singletonList(this.typedVariable));
        Assertions.assertNotNull((Object)typedValues);
        Assertions.assertEquals((int)1, (int)typedValues.size());
        Assertions.assertTrue((boolean)(typedValues.iterator().next() instanceof UnitValue));
    }

    @Test
    void modelToTracingTypedValueMap() {
        Assertions.assertNull((Object)MessagingUtils.modelToTracingTypedValueMap(null));
        Map valueMap = MessagingUtils.modelToTracingTypedValueMap(Collections.singletonList(this.typedVariable));
        Assertions.assertNotNull((Object)valueMap);
        Assertions.assertEquals((int)1, (int)valueMap.size());
        Assertions.assertTrue((boolean)valueMap.containsKey("name"));
        Assertions.assertTrue((boolean)(valueMap.get("name") instanceof UnitValue));
    }
}

