/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import io.cloudevents.CloudEvent;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import java.net.URI;
import java.util.Collections;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.kie.kogito.tracing.decision.event.CloudEventUtils;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@QuarkusTest
@QuarkusTestResource(value=KafkaQuarkusTestResource.class)
public class ExplainabilityResultConsumerIT {
    @ConfigProperty(name="kafka.bootstrap.servers")
    String kafkaBootstrapServers;
    @InjectMock
    TrustyService trustyService;
    KafkaClient kafkaClient;

    @Test
    public void explainabilityResultIsProcessedAndStored() {
        this.kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
        String executionId = "executionId";
        ((TrustyService)Mockito.doNothing().when((Object)this.trustyService)).storeExplainabilityResult((String)ArgumentMatchers.eq((Object)executionId), (ExplainabilityResult)ArgumentMatchers.any(ExplainabilityResult.class));
        this.kafkaClient.produce(ExplainabilityResultConsumerIT.buildCloudEventJsonString(ExplainabilityResultDto.buildSucceeded((String)executionId, Collections.emptyMap())), "trusty-explainability-result-test");
        ((TrustyService)Mockito.verify((Object)this.trustyService, (VerificationMode)Mockito.timeout((long)3000L).times(1))).storeExplainabilityResult((String)ArgumentMatchers.any(String.class), (ExplainabilityResult)ArgumentMatchers.any(ExplainabilityResult.class));
    }

    public static CloudEvent buildExplainabilityCloudEvent(ExplainabilityResultDto resultDto) {
        return (CloudEvent)CloudEventUtils.build((String)resultDto.getExecutionId(), (URI)URI.create("explainabilityResult/test"), (Object)resultDto, ExplainabilityResultDto.class).orElseThrow(IllegalStateException::new);
    }

    public static String buildCloudEventJsonString(ExplainabilityResultDto resultDto) {
        return (String)CloudEventUtils.encode((CloudEvent)ExplainabilityResultConsumerIT.buildExplainabilityCloudEvent(resultDto)).orElseThrow(IllegalStateException::new);
    }
}

