/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Test;
import org.kie.kogito.kafka.KafkaClient;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.TrustyServiceTestUtils;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@QuarkusTest
@QuarkusTestResource(value=KafkaQuarkusTestResource.class)
public class TraceEventConsumerIT {
    @ConfigProperty(name="kafka.bootstrap.servers")
    private String kafkaBootstrapServers;
    @InjectMock
    TrustyService trustyService;
    KafkaClient kafkaClient;

    @Test
    public void eventLoopIsNotStoppedWithException() {
        this.kafkaClient = new KafkaClient(this.kafkaBootstrapServers);
        String executionIdException = "idException";
        String executionIdNoException = "idNoException";
        ((TrustyService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Something really bad")}).when((Object)this.trustyService)).processDecision((String)ArgumentMatchers.eq((Object)executionIdException), (String)ArgumentMatchers.any(String.class), (Decision)ArgumentMatchers.any(Decision.class));
        ((TrustyService)Mockito.doNothing().when((Object)this.trustyService)).processDecision((String)ArgumentMatchers.eq((Object)executionIdNoException), (String)ArgumentMatchers.any(String.class), (Decision)ArgumentMatchers.any(Decision.class));
        this.kafkaClient.produce(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildCorrectTraceEvent(executionIdException)), "kogito-tracing-test");
        this.kafkaClient.produce(TrustyServiceTestUtils.buildCloudEventJsonString(TrustyServiceTestUtils.buildCorrectTraceEvent(executionIdNoException)), "kogito-tracing-test");
        ((TrustyService)Mockito.verify((Object)this.trustyService, (VerificationMode)Mockito.timeout((long)3000L).times(2))).processDecision((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (Decision)ArgumentMatchers.any(Decision.class));
    }
}

