/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.testcontainers.quarkus.InfinispanQuarkusTestResource;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.models.MatchedExecutionHeaders;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.Execution;

@QuarkusTest
@QuarkusTestResource(value=InfinispanQuarkusTestResource.class)
public class TrustyServiceIT {
    @Inject
    TrustyService trustyService;
    @Inject
    TrustyStorageService trustyStorageService;

    @BeforeEach
    public void setup() {
        this.trustyStorageService.getExplainabilityResultStorage().clear();
        this.trustyStorageService.getDecisionsStorage().clear();
        this.trustyStorageService.getModelStorage().clear();
    }

    @Test
    public void testStoreAndRetrieveExecution() {
        this.storeExecution("myExecution", 1591692958000L);
        OffsetDateTime from = OffsetDateTime.ofInstant(Instant.ofEpochMilli(1591692957000L), ZoneOffset.UTC);
        OffsetDateTime to = OffsetDateTime.ofInstant(Instant.ofEpochMilli(1591692959000L), ZoneOffset.UTC);
        MatchedExecutionHeaders result = this.trustyService.getExecutionHeaders(from, to, 100, 0, "");
        Assertions.assertEquals((int)1, (int)result.getExecutions().size());
        Assertions.assertEquals((Object)"myExecution", (Object)((Execution)result.getExecutions().get(0)).getExecutionId());
    }

    @Test
    public void givenTwoExecutionsWhenTheQueryExcludesOneExecutionThenOnlyOneExecutionIsReturned() {
        this.storeExecution("myExecution", 1591692950000L);
        this.storeExecution("executionId2", 1591692958000L);
        OffsetDateTime from = OffsetDateTime.ofInstant(Instant.ofEpochMilli(1591692940000L), ZoneOffset.UTC);
        OffsetDateTime to = OffsetDateTime.ofInstant(Instant.ofEpochMilli(1591692955000L), ZoneOffset.UTC);
        MatchedExecutionHeaders result = this.trustyService.getExecutionHeaders(from, to, 100, 0, "");
        Assertions.assertEquals((int)1, (int)result.getExecutions().size());
        Assertions.assertEquals((Object)"myExecution", (Object)((Execution)result.getExecutions().get(0)).getExecutionId());
    }

    @Test
    public void givenTwoExecutionsWhenThePrefixIsUsedThenOnlyOneExecutionIsReturned() {
        this.storeExecution("myExecution", 1591692950000L);
        this.storeExecution("executionId2", 1591692958000L);
        OffsetDateTime from = OffsetDateTime.ofInstant(Instant.ofEpochMilli(1591692940000L), ZoneOffset.UTC);
        OffsetDateTime to = OffsetDateTime.ofInstant(Instant.ofEpochMilli(1591692959000L), ZoneOffset.UTC);
        MatchedExecutionHeaders result = this.trustyService.getExecutionHeaders(from, to, 100, 0, "my");
        Assertions.assertEquals((int)1, (int)result.getExecutions().size());
        Assertions.assertEquals((Object)"myExecution", (Object)((Execution)result.getExecutions().get(0)).getExecutionId());
    }

    @Test
    public void givenAnExecutionWhenGetDecisionByIdIsCalledThenTheExecutionIsReturned() {
        String executionId = "myExecution";
        this.storeExecution(executionId, 1591692950000L);
        Decision result = this.trustyService.getDecisionById(executionId);
        Assertions.assertEquals((Object)executionId, (Object)result.getExecutionId());
    }

    @Test
    public void givenADuplicatedDecisionWhenTheDecisionIsStoredThenAnExceptionIsRaised() {
        String executionId = "myExecution";
        this.storeExecution(executionId, 1591692950000L);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.storeExecution(executionId, 1591692950000L));
    }

    @Test
    public void givenNoExecutionsWhenADecisionIsRetrievedThenAnExceptionIsRaised() {
        String executionId = "myExecution";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.getDecisionById(executionId));
    }

    @Test
    public void givenAModelWhenGetModelByIdIsCalledThenTheModelIsReturned() {
        String model = "definition";
        String modelId = "name:namespace";
        this.storeModel(model);
        String result = this.trustyService.getModelById(modelId);
        Assertions.assertEquals((Object)model, (Object)result);
    }

    @Test
    public void givenADuplicatedModelWhenTheModelIsStoredThenAnExceptionIsRaised() {
        String model = "definition";
        this.storeModel(model);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.storeModel(model));
    }

    @Test
    public void givenNoModelsWhenAModelIsRetrievedThenAnExceptionIsRaised() {
        String modelId = "name:namespace";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.getModelById(modelId));
    }

    private Decision storeExecution(String executionId, Long timestamp) {
        Decision decision = new Decision();
        decision.setExecutionId(executionId);
        decision.setExecutionTimestamp(timestamp);
        this.trustyService.storeDecision(decision.getExecutionId(), decision);
        return decision;
    }

    private String storeModel(String model) {
        this.trustyService.storeModel("groupId", "artifactId", "version", "name", "namespace", model);
        return model;
    }
}

