/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.ExplainabilityRequestDto;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.trusty.service.TrustyServiceImpl;
import org.kie.kogito.trusty.service.messaging.outgoing.ExplainabilityRequestProducer;
import org.kie.kogito.trusty.service.mocks.StorageImplMock;
import org.kie.kogito.trusty.service.models.MatchedExecutionHeaders;
import org.kie.kogito.trusty.storage.api.TrustyStorageService;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.Execution;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityStatus;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TrustyServiceTest {
    private static final String TEST_EXECUTION_ID = "executionId";
    private static final String TEST_MODEL = "definition";
    private static final String TEST_MODEL_ID = "name:namespace";
    private static final String TEST_SERVICE_URL = "http://localhost:8080/model";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private ExplainabilityRequestProducer explainabilityRequestProducerMock;
    private TrustyStorageService trustyStorageServiceMock;
    private TrustyServiceImpl trustyService;

    @BeforeEach
    void setup() {
        this.explainabilityRequestProducerMock = (ExplainabilityRequestProducer)Mockito.mock(ExplainabilityRequestProducer.class);
        this.trustyStorageServiceMock = (TrustyStorageService)Mockito.mock(TrustyStorageService.class);
        this.trustyService = new TrustyServiceImpl(Boolean.valueOf(false), this.explainabilityRequestProducerMock, this.trustyStorageServiceMock);
    }

    @Test
    void givenADecisionWhenStoreDecisionIsCalledThenNoExceptionsAreThrown() {
        Decision decision = new Decision();
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.put(ArgumentMatchers.any(Object.class), ArgumentMatchers.any(Object.class))).thenReturn((Object)decision);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn((Object)storageMock);
        Assertions.assertDoesNotThrow(() -> this.trustyService.storeDecision("test", decision));
    }

    @Test
    void givenADecisionWhenADecisionIsStoredAndRetrievedThenTheOriginalObjectIsReturned() {
        Decision decision = new Decision();
        decision.setExecutionId(TEST_EXECUTION_ID);
        Query queryMock = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)queryMock.filter((List)ArgumentMatchers.any(List.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.offset((Integer)ArgumentMatchers.any(Integer.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.sort((List)ArgumentMatchers.any(List.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.execute()).thenReturn(List.of(decision));
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.put(ArgumentMatchers.eq((Object)TEST_EXECUTION_ID), ArgumentMatchers.any(Object.class))).thenReturn((Object)decision);
        Mockito.when((Object)storageMock.containsKey(ArgumentMatchers.eq((Object)TEST_EXECUTION_ID))).thenReturn((Object)false);
        Mockito.when((Object)storageMock.query()).thenReturn((Object)queryMock);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn((Object)storageMock);
        this.trustyService.storeDecision(TEST_EXECUTION_ID, decision);
        MatchedExecutionHeaders result = this.trustyService.getExecutionHeaders(OffsetDateTime.now().minusDays(1L), OffsetDateTime.now(), 100, 0, "");
        Assertions.assertEquals((int)1, (int)result.getExecutions().size());
        Assertions.assertEquals((Object)decision.getExecutionId(), (Object)((Execution)result.getExecutions().get(0)).getExecutionId());
    }

    @Test
    void givenManyExecutionsThenPaginationWorksProperly() {
        ArrayList decisions = new ArrayList();
        IntStream.range(0, 10).forEach(x -> {
            Decision d = new Decision();
            d.setExecutionId(String.valueOf(x));
            decisions.add(d);
        });
        Query queryMock = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)queryMock.filter((List)ArgumentMatchers.any(List.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.sort((List)ArgumentMatchers.any(List.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.execute()).thenReturn(decisions);
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        decisions.forEach(x -> {
            Mockito.when((Object)storageMock.put(ArgumentMatchers.eq((Object)x.getExecutionId()), ArgumentMatchers.any(Object.class))).thenReturn(x);
            Mockito.when((Object)storageMock.containsKey(ArgumentMatchers.eq((Object)x.getExecutionId()))).thenReturn((Object)false);
        });
        Mockito.when((Object)storageMock.query()).thenReturn((Object)queryMock);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn((Object)storageMock);
        decisions.forEach(x -> this.trustyService.storeDecision(x.getExecutionId(), x));
        MatchedExecutionHeaders result = this.trustyService.getExecutionHeaders(OffsetDateTime.now().minusDays(1L), OffsetDateTime.now(), 3, 5, "");
        Assertions.assertEquals((int)3, (int)result.getExecutions().size());
        Assertions.assertEquals((int)decisions.size(), (int)result.getAvailableResults());
        result = this.trustyService.getExecutionHeaders(OffsetDateTime.now().minusDays(1L), OffsetDateTime.now(), 100, 5, "");
        Assertions.assertEquals((int)5, (int)result.getExecutions().size());
        Assertions.assertEquals((int)decisions.size(), (int)result.getAvailableResults());
    }

    @Test
    void givenNoExecutionsNoExceptionsAreRaised() {
        Query queryMock = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)queryMock.filter((List)ArgumentMatchers.any(List.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.sort((List)ArgumentMatchers.any(List.class))).thenReturn((Object)queryMock);
        Mockito.when((Object)queryMock.execute()).thenReturn(new ArrayList());
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.query()).thenReturn((Object)queryMock);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn((Object)storageMock);
        MatchedExecutionHeaders result = this.trustyService.getExecutionHeaders(OffsetDateTime.now().minusDays(1L), OffsetDateTime.now(), 100, 0, "");
        Assertions.assertEquals((int)0, (int)result.getExecutions().size());
        Assertions.assertEquals((int)0, (int)result.getAvailableResults());
    }

    @Test
    void givenADecisionWhenADecisionIsStoredAndRetrievedByIdThenTheOriginalObjectIsReturned() {
        Decision decision = new Decision();
        decision.setExecutionId(TEST_EXECUTION_ID);
        StorageImplMock storageMock = new StorageImplMock(Decision.class);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn(storageMock);
        this.trustyService.storeDecision(TEST_EXECUTION_ID, decision);
        Decision result = this.trustyService.getDecisionById(TEST_EXECUTION_ID);
        Assertions.assertEquals((Object)TEST_EXECUTION_ID, (Object)result.getExecutionId());
    }

    @Test
    void givenADecisionToProcessWhenExplainabilityIsEnabledThenRequestIsSent() throws JsonProcessingException {
        this.trustyService.enableExplainability();
        Decision decision = new Decision(TEST_EXECUTION_ID, TEST_SERVICE_URL, Long.valueOf(1591692950000L), Boolean.valueOf(true), null, "model", "modelNamespace", List.of(new DecisionInput("1", "Input1", TypedVariable.buildCollection((String)"testList", (String)"string", List.of(TypedVariable.buildUnit(null, (String)"string", (JsonNode)TrustyServiceTest.toJsonNode("\"ONE\"")), TypedVariable.buildUnit(null, (String)"string", (JsonNode)TrustyServiceTest.toJsonNode("\"TWO\""))))), new DecisionInput("2", "Input2", TypedVariable.buildStructure((String)"author", (String)"Person", List.of(TypedVariable.buildUnit((String)"Name", (String)"string", (JsonNode)TrustyServiceTest.toJsonNode("\"George Orwell\"")), TypedVariable.buildUnit((String)"Age", (String)"number", (JsonNode)TrustyServiceTest.toJsonNode("45")))))), List.of(new DecisionOutcome("OUT1", "Result", "SUCCEEDED", TypedVariable.buildUnit((String)"Result", (String)"string", (JsonNode)TrustyServiceTest.toJsonNode("\"YES\"")), Collections.emptyList(), Collections.emptyList())));
        Storage decisionStorageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)decisionStorageMock.containsKey((Object)((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID)))).thenReturn((Object)false);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn((Object)decisionStorageMock);
        this.trustyService.processDecision(TEST_EXECUTION_ID, TEST_SERVICE_URL, decision);
        ((ExplainabilityRequestProducer)Mockito.verify((Object)this.explainabilityRequestProducerMock)).sendEvent((ExplainabilityRequestDto)ArgumentMatchers.any());
    }

    @Test
    void givenADecisionToProcessThatAlreadyExistsWhenExplainabilityIsEnabledThenExceptionIsThrown() {
        this.trustyService.enableExplainability();
        Decision decision = new Decision();
        decision.setExecutionId(TEST_EXECUTION_ID);
        Storage decisionStorageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)decisionStorageMock.containsKey((Object)((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID)))).thenReturn((Object)true);
        Mockito.when((Object)this.trustyStorageServiceMock.getDecisionsStorage()).thenReturn((Object)decisionStorageMock);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.processDecision(TEST_EXECUTION_ID, TEST_SERVICE_URL, decision));
        ((ExplainabilityRequestProducer)Mockito.verify((Object)this.explainabilityRequestProducerMock, (VerificationMode)Mockito.never())).sendEvent((ExplainabilityRequestDto)ArgumentMatchers.any());
    }

    @Test
    void givenAModelWhenStoreModelIsCalledThenNoExceptionsAreThrown() {
        String model = TEST_MODEL;
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.put(ArgumentMatchers.any(Object.class), ArgumentMatchers.any(Object.class))).thenReturn((Object)model);
        Mockito.when((Object)this.trustyStorageServiceMock.getModelStorage()).thenReturn((Object)storageMock);
        Assertions.assertDoesNotThrow(() -> this.trustyService.storeModel("groupId", "artifactId", "version", "name", "namespace", model));
    }

    @Test
    void givenAModelWhenStoreModelIsCalledMoreThanOnceForSameModelThenExceptionIsThrown() {
        String modelId = TEST_MODEL_ID;
        String model = TEST_MODEL;
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.containsKey((Object)modelId)).thenReturn((Object)true);
        Mockito.when((Object)storageMock.put(ArgumentMatchers.any(Object.class), ArgumentMatchers.any(Object.class))).thenReturn((Object)model);
        Mockito.when((Object)this.trustyStorageServiceMock.getModelStorage()).thenReturn((Object)storageMock);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.storeModel("groupId", "artifactId", "version", "name", "namespace", model));
    }

    @Test
    void givenAModelWhenAModelIsStoredAndRetrievedByIdThenTheOriginalObjectIsReturned() {
        String modelId = TEST_MODEL_ID;
        String model = TEST_MODEL;
        StorageImplMock storageMock = new StorageImplMock(String.class);
        Mockito.when((Object)this.trustyStorageServiceMock.getModelStorage()).thenReturn(storageMock);
        this.trustyService.storeModel("groupId", "artifactId", "version", "name", "namespace", model);
        String result = this.trustyService.getModelById(modelId);
        Assertions.assertEquals((Object)model, (Object)result);
    }

    @Test
    void whenAModelIsNotStoredAndRetrievedByIdThenExceptionIsThrown() {
        String modelId = TEST_MODEL_ID;
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.containsKey((Object)modelId)).thenReturn((Object)false);
        Mockito.when((Object)this.trustyStorageServiceMock.getModelStorage()).thenReturn((Object)storageMock);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.getModelById(modelId));
    }

    @Test
    void givenAnExplainabilityResultWhenStoreModelIsCalledThenNoExceptionsAreThrown() {
        ExplainabilityResult result = new ExplainabilityResult(TEST_EXECUTION_ID, ExplainabilityStatus.SUCCEEDED, null, Collections.emptyList());
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)((ExplainabilityResult)storageMock.put((Object)((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID)), (Object)((ExplainabilityResult)ArgumentMatchers.any(ExplainabilityResult.class))))).thenReturn((Object)result);
        Mockito.when((Object)this.trustyStorageServiceMock.getExplainabilityResultStorage()).thenReturn((Object)storageMock);
        Assertions.assertDoesNotThrow(() -> this.trustyService.storeExplainabilityResult(TEST_EXECUTION_ID, result));
    }

    @Test
    void givenAnExplainabilityResultWhenStoreModelIsCalledMoreThanOnceForSameModelThenExceptionIsThrown() {
        ExplainabilityResult result = new ExplainabilityResult(TEST_EXECUTION_ID, ExplainabilityStatus.SUCCEEDED, null, Collections.emptyList());
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.containsKey((Object)((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID)))).thenReturn((Object)true);
        Mockito.when((Object)((ExplainabilityResult)storageMock.put((Object)((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID)), (Object)((ExplainabilityResult)ArgumentMatchers.any(ExplainabilityResult.class))))).thenReturn((Object)result);
        Mockito.when((Object)this.trustyStorageServiceMock.getExplainabilityResultStorage()).thenReturn((Object)storageMock);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.storeExplainabilityResult(TEST_EXECUTION_ID, result));
    }

    @Test
    void givenAnExplainabilityResultWhenAnExplainabilityResultIsStoredAndRetrievedByIdThenTheOriginalObjectIsReturned() {
        ExplainabilityResult result = new ExplainabilityResult(TEST_EXECUTION_ID, ExplainabilityStatus.SUCCEEDED, null, Collections.emptyList());
        StorageImplMock storageMock = new StorageImplMock(String.class);
        Mockito.when((Object)this.trustyStorageServiceMock.getExplainabilityResultStorage()).thenReturn(storageMock);
        this.trustyService.storeExplainabilityResult(TEST_EXECUTION_ID, result);
        Assertions.assertEquals((Object)result, (Object)this.trustyService.getExplainabilityResultById(TEST_EXECUTION_ID));
    }

    @Test
    void givenAnExplainabilityResultNotStoredWhenRetrievedByIdThenExceptionIsThrown() {
        Storage storageMock = (Storage)Mockito.mock(Storage.class);
        Mockito.when((Object)storageMock.containsKey((Object)((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID)))).thenReturn((Object)false);
        Mockito.when((Object)this.trustyStorageServiceMock.getExplainabilityResultStorage()).thenReturn((Object)storageMock);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trustyService.getExplainabilityResultById(TEST_EXECUTION_ID));
    }

    private static JsonNode toJsonNode(String jsonString) throws JsonProcessingException {
        return MAPPER.reader().readTree(jsonString);
    }
}

