/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.log.ResponseLoggingFilter;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.tracing.decision.event.message.MessageLevel;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.responses.DecisionOutcomeResponse;
import org.kie.kogito.trusty.service.responses.DecisionOutcomesResponse;
import org.kie.kogito.trusty.service.responses.DecisionStructuredInputsResponse;
import org.kie.kogito.trusty.service.responses.ExecutionHeaderResponse;
import org.kie.kogito.trusty.service.responses.ExecutionType;
import org.kie.kogito.trusty.service.responses.MessageExceptionFieldResponse;
import org.kie.kogito.trusty.service.responses.MessageResponse;
import org.kie.kogito.trusty.service.responses.TypedVariableResponse;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.Message;
import org.kie.kogito.trusty.storage.api.model.MessageExceptionField;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@QuarkusTest
class DecisionsApiV1IT {
    private static final String TEST_EXECUTION_ID = "executionId";
    private static final String TEST_MODEL_NAME = "testModel";
    private static final String TEST_MODEL_NAMESPACE = "testNamespace";
    private static final String TEST_SOURCE_URL = "http://localhost:8080/testModel";
    private static final String TEST_OUTCOME_ID = "FirstOutcome";
    private static final long TEST_EXECUTION_TIMESTAMP = 1591692950000L;
    private static final OffsetDateTime TEST_EXECUTION_DATE = OffsetDateTime.ofInstant(Instant.ofEpochMilli(1591692950000L), ZoneId.of("UTC"));
    @InjectMock
    TrustyService executionService;

    DecisionsApiV1IT() {
    }

    @Test
    void testGetExecutionById() throws Exception {
        this.assertGetExecutionByIdCorrectResponse(ListStatus.FULL, ListStatus.FULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.FULL, ListStatus.EMPTY);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.FULL, ListStatus.NULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.EMPTY, ListStatus.FULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.EMPTY, ListStatus.EMPTY);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.EMPTY, ListStatus.NULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.NULL, ListStatus.FULL);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.NULL, ListStatus.EMPTY);
        this.assertGetExecutionByIdCorrectResponse(ListStatus.NULL, ListStatus.NULL);
        this.assertBadRequestWithoutDecision("");
    }

    @Test
    void testGetStructuredInputs() throws Exception {
        this.assertGetStructuredInputsCorrectFullResponse(ListStatus.FULL);
        this.assertGetStructuredInputsCorrectFullResponse(ListStatus.EMPTY);
        this.assertGetStructuredInputsCorrectFullResponse(ListStatus.NULL);
        this.assertGetStructuredInputsCorrectEmptyResponse(ListStatus.FULL);
        this.assertGetStructuredInputsCorrectEmptyResponse(ListStatus.EMPTY);
        this.assertGetStructuredInputsCorrectEmptyResponse(ListStatus.NULL);
        this.assertBadRequestWithDecision("/structuredInputs", ListStatus.NULL, ListStatus.FULL);
        this.assertBadRequestWithDecision("/structuredInputs", ListStatus.NULL, ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/structuredInputs", ListStatus.NULL, ListStatus.NULL);
        this.assertBadRequestWithoutDecision("/structuredInputs");
    }

    @Test
    void testGetOutcomes() throws Exception {
        this.assertGetOutcomesCorrectFullResponse(ListStatus.FULL);
        this.assertGetOutcomesCorrectEmptyResponse(ListStatus.FULL);
        this.assertGetOutcomesCorrectNullResponse(ListStatus.FULL);
        this.assertGetOutcomesCorrectFullResponse(ListStatus.EMPTY);
        this.assertGetOutcomesCorrectEmptyResponse(ListStatus.EMPTY);
        this.assertGetOutcomesCorrectNullResponse(ListStatus.EMPTY);
        this.assertGetOutcomesCorrectFullResponse(ListStatus.NULL);
        this.assertGetOutcomesCorrectEmptyResponse(ListStatus.NULL);
        this.assertGetOutcomesCorrectNullResponse(ListStatus.NULL);
        this.assertBadRequestWithoutDecision("/structuredInputs");
    }

    @Test
    void testGetOutcomeById() throws Exception {
        this.assertGetOutcomeByIdCorrectResponse(ListStatus.FULL);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.FULL, ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.FULL, ListStatus.NULL);
        this.assertGetOutcomeByIdCorrectResponse(ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.EMPTY, ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.EMPTY, ListStatus.NULL);
        this.assertGetOutcomeByIdCorrectResponse(ListStatus.NULL);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.NULL, ListStatus.EMPTY);
        this.assertBadRequestWithDecision("/outcomes/FirstOutcome", ListStatus.NULL, ListStatus.NULL);
        this.assertBadRequestWithoutDecision("/structuredInputs");
    }

    private void assertBadRequestWithDecision(String path, ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        ((ValidatableResponse)this.get(path).then()).statusCode(400);
    }

    private void assertBadRequestWithoutDecision(String path) {
        this.mockServiceWithoutDecision();
        ((ValidatableResponse)this.get(path).then()).statusCode(400);
    }

    private void assertGetExecutionByIdCorrectResponse(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, outcomesStatus);
        ExecutionHeaderResponse response = (ExecutionHeaderResponse)this.get().as(ExecutionHeaderResponse.class);
        this.assertExecutionHeaderResponse(this.buildExecutionHeaderResponse(), response);
    }

    private void assertGetOutcomeByIdCorrectResponse(ListStatus inputsStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, ListStatus.FULL);
        DecisionOutcomeResponse response = (DecisionOutcomeResponse)this.get("/outcomes/FirstOutcome").as(DecisionOutcomeResponse.class);
        this.assertDecisionOutcomeResponse(this.buildDecisionOutcomeResponse(), response);
    }

    private void assertGetOutcomesCorrectEmptyResponse(ListStatus inputsStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, ListStatus.EMPTY);
        DecisionOutcomesResponse response = (DecisionOutcomesResponse)this.get("/outcomes").as(DecisionOutcomesResponse.class);
        this.assertDecisionOutcomesResponse(this.buildDecisionOutcomesResponse(ListStatus.EMPTY), response);
    }

    private void assertGetOutcomesCorrectFullResponse(ListStatus inputsStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, ListStatus.FULL);
        DecisionOutcomesResponse response = (DecisionOutcomesResponse)this.get("/outcomes").as(DecisionOutcomesResponse.class);
        this.assertDecisionOutcomesResponse(this.buildDecisionOutcomesResponse(ListStatus.FULL), response);
    }

    private void assertGetOutcomesCorrectNullResponse(ListStatus inputsStatus) throws Exception {
        this.mockServiceWithDecision(inputsStatus, ListStatus.NULL);
        DecisionOutcomesResponse response = (DecisionOutcomesResponse)this.get("/outcomes").as(DecisionOutcomesResponse.class);
        this.assertDecisionOutcomesResponse(this.buildDecisionOutcomesResponse(ListStatus.NULL), response);
    }

    private void assertGetStructuredInputsCorrectEmptyResponse(ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(ListStatus.EMPTY, outcomesStatus);
        DecisionStructuredInputsResponse response = (DecisionStructuredInputsResponse)this.get("/structuredInputs").as(DecisionStructuredInputsResponse.class);
        this.assertDecisionStructuredInputResponse(this.buildDecisionStructuredInputsResponse(ListStatus.EMPTY), response);
    }

    private void assertGetStructuredInputsCorrectFullResponse(ListStatus outcomesStatus) throws Exception {
        this.mockServiceWithDecision(ListStatus.FULL, outcomesStatus);
        DecisionStructuredInputsResponse response = (DecisionStructuredInputsResponse)this.get("/structuredInputs").as(DecisionStructuredInputsResponse.class);
        this.assertDecisionStructuredInputResponse(this.buildDecisionStructuredInputsResponse(ListStatus.FULL), response);
    }

    private <T> void assertCollection(Collection<T> expected, Collection<T> actual, BiConsumer<T, T> itemAssertor) {
        if (expected == null) {
            Assertions.assertNull(actual);
            return;
        }
        Assertions.assertSame((Object)expected.size(), (Object)actual.size());
        Iterator<T> itExpected = expected.iterator();
        Iterator<T> itActual = actual.iterator();
        while (itExpected.hasNext() && itActual.hasNext()) {
            itemAssertor.accept(itExpected.next(), itActual.next());
        }
    }

    private void assertDecisionOutcomeResponse(DecisionOutcomeResponse expected, DecisionOutcomeResponse actual) {
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)expected.getOutcomeId(), (Object)actual.getOutcomeId());
        Assertions.assertEquals((Object)expected.getOutcomeName(), (Object)actual.getOutcomeName());
        Assertions.assertEquals((Object)expected.getEvaluationStatus(), (Object)actual.getEvaluationStatus());
        this.assertTypedVariableResponse(expected.getOutcomeResult(), actual.getOutcomeResult());
        this.assertCollection(expected.getOutcomeInputs(), actual.getOutcomeInputs(), this::assertTypedVariableResponse);
        this.assertCollection(expected.getMessages(), actual.getMessages(), this::assertMessageResponse);
    }

    private void assertDecisionOutcomesResponse(DecisionOutcomesResponse expected, DecisionOutcomesResponse actual) {
        Assertions.assertNotNull((Object)actual);
        this.assertExecutionHeaderResponse(expected.getHeader(), actual.getHeader());
        this.assertCollection(expected.getOutcomes(), actual.getOutcomes(), this::assertDecisionOutcomeResponse);
    }

    private void assertDecisionStructuredInputResponse(DecisionStructuredInputsResponse expected, DecisionStructuredInputsResponse actual) {
        Assertions.assertNotNull((Object)actual);
        this.assertCollection(expected.getInputs(), actual.getInputs(), this::assertTypedVariableResponse);
    }

    private void assertExecutionHeaderResponse(ExecutionHeaderResponse expected, ExecutionHeaderResponse actual) {
        Assertions.assertNotNull((Object)actual);
        Assertions.assertSame((Object)expected.getExecutionType(), (Object)actual.getExecutionType());
        Assertions.assertEquals((Object)expected.getExecutionId(), (Object)actual.getExecutionId());
        Assertions.assertEquals((Object)expected.getExecutionDate(), (Object)actual.getExecutionDate());
        Assertions.assertEquals((Object)expected.getExecutorName(), (Object)actual.getExecutorName());
        Assertions.assertEquals((Object)expected.hasSucceeded(), (Object)actual.hasSucceeded());
        Assertions.assertEquals((Object)expected.getExecutedModelName(), (Object)actual.getExecutedModelName());
        Assertions.assertEquals((Object)expected.getExecutedModelNamespace(), (Object)actual.getExecutedModelNamespace());
    }

    private void assertMessageResponse(MessageResponse expected, MessageResponse actual) {
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)expected.getLevel(), (Object)actual.getLevel());
        Assertions.assertEquals((Object)expected.getCategory(), (Object)actual.getCategory());
        Assertions.assertEquals((Object)expected.getType(), (Object)actual.getType());
        Assertions.assertEquals((Object)expected.getSourceId(), (Object)actual.getSourceId());
        Assertions.assertEquals((Object)expected.getText(), (Object)actual.getText());
        this.assertMessageExceptionFieldResponse(expected.getException(), actual.getException());
    }

    private void assertMessageExceptionFieldResponse(MessageExceptionFieldResponse expected, MessageExceptionFieldResponse actual) {
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)expected.getMessage(), (Object)actual.getMessage());
        Assertions.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        if (expected.getCause() == null) {
            Assertions.assertNull((Object)actual.getCause());
        } else {
            this.assertMessageExceptionFieldResponse(expected.getCause(), actual.getCause());
        }
    }

    private void assertTypedVariableResponse(TypedVariableResponse expected, TypedVariableResponse actual) {
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assertions.assertEquals((Object)expected.getTypeRef(), (Object)actual.getTypeRef());
        Assertions.assertEquals((Object)expected.getValue(), (Object)actual.getValue());
        this.assertCollection(expected.getComponents(), actual.getComponents(), Assertions::assertEquals);
    }

    private Decision buildValidDecision(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Decision decision = new Decision();
        decision.setExecutionId(TEST_EXECUTION_ID);
        decision.setSourceUrl(TEST_SOURCE_URL);
        decision.setExecutionTimestamp(Long.valueOf(1591692950000L));
        decision.setSuccess(Boolean.valueOf(true));
        decision.setExecutedModelName(TEST_MODEL_NAME);
        decision.setExecutedModelNamespace(TEST_MODEL_NAMESPACE);
        switch (inputsStatus) {
            case EMPTY: {
                decision.setInputs(List.of());
                break;
            }
            case FULL: {
                decision.setInputs(List.of(new DecisionInput("1", "first", TypedVariable.buildUnit((String)"first", (String)"FirstInput", (JsonNode)mapper.readTree("\"Hello\""))), new DecisionInput("2", "second", TypedVariable.buildUnit((String)"second", (String)"SecondInput", (JsonNode)mapper.readTree("12345")))));
            }
        }
        switch (outcomesStatus) {
            case EMPTY: {
                decision.setOutcomes(List.of());
                break;
            }
            case FULL: {
                decision.setOutcomes(List.of(new DecisionOutcome(TEST_OUTCOME_ID, "ONE", "SUCCEEDED", TypedVariable.buildUnit((String)"result", (String)"ResType", (JsonNode)mapper.readTree("\"The First Outcome\"")), List.of(), List.of(new Message(MessageLevel.WARNING, "INTERNAL", "TEST", "testSrc", "Test message", new MessageExceptionField("TestException", "Test exception message", new MessageExceptionField("TestExceptionCause", "Test exception cause message", null)))))));
            }
        }
        return decision;
    }

    private DecisionOutcomeResponse buildDecisionOutcomeResponse() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return new DecisionOutcomeResponse(TEST_OUTCOME_ID, "ONE", "SUCCEEDED", new TypedVariableResponse("result", "ResType", mapper.readTree("\"The First Outcome\""), null), Collections.emptyList(), List.of(new MessageResponse("WARNING", "INTERNAL", "TEST", "testSrc", "Test message", new MessageExceptionFieldResponse("TestException", "Test exception message", new MessageExceptionFieldResponse("TestExceptionCause", "Test exception cause message", null)))), false);
    }

    private DecisionOutcomesResponse buildDecisionOutcomesResponse(ListStatus outcomesStatus) throws JsonProcessingException {
        switch (outcomesStatus) {
            case NULL: {
                return new DecisionOutcomesResponse(this.buildExecutionHeaderResponse(), null);
            }
            case EMPTY: {
                return new DecisionOutcomesResponse(this.buildExecutionHeaderResponse(), Collections.emptyList());
            }
            case FULL: {
                return new DecisionOutcomesResponse(this.buildExecutionHeaderResponse(), List.of(this.buildDecisionOutcomeResponse()));
            }
        }
        throw new IllegalStateException();
    }

    private DecisionStructuredInputsResponse buildDecisionStructuredInputsResponse(ListStatus inputsStatus) throws JsonProcessingException {
        switch (inputsStatus) {
            case NULL: {
                return new DecisionStructuredInputsResponse(null);
            }
            case EMPTY: {
                return new DecisionStructuredInputsResponse(Collections.emptyList());
            }
            case FULL: {
                ObjectMapper mapper = new ObjectMapper();
                return new DecisionStructuredInputsResponse(List.of(new TypedVariableResponse("first", "FirstInput", mapper.readTree("\"Hello\""), null), new TypedVariableResponse("second", "SecondInput", mapper.readTree("12345"), null)));
            }
        }
        throw new IllegalStateException();
    }

    private ExecutionHeaderResponse buildExecutionHeaderResponse() {
        return new ExecutionHeaderResponse(TEST_EXECUTION_ID, TEST_EXECUTION_DATE, Boolean.valueOf(true), null, TEST_MODEL_NAME, TEST_MODEL_NAMESPACE, ExecutionType.DECISION);
    }

    private Response get() {
        return this.get("");
    }

    private Response get(String endpoint) {
        return (Response)RestAssured.given().filter((Filter)new ResponseLoggingFilter()).contentType(ContentType.JSON).when().get("/executions/decisions/executionId" + endpoint, new Object[0]);
    }

    private void mockServiceWithDecision(ListStatus inputsStatus, ListStatus outcomesStatus) throws Exception {
        Mockito.when((Object)this.executionService.getDecisionById((String)ArgumentMatchers.eq((Object)TEST_EXECUTION_ID))).thenReturn((Object)this.buildValidDecision(inputsStatus, outcomesStatus));
    }

    private void mockServiceWithoutDecision() {
        Mockito.when((Object)this.executionService.getDecisionById(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new IllegalArgumentException("Execution does not exist.")});
    }

    private static enum ListStatus {
        FULL,
        EMPTY,
        NULL;

    }
}

