/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.PathValueOperation;
import com.google.common.base.Equivalence;

public final class TestOperation
extends PathValueOperation {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    @JsonCreator
    public TestOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super("test", path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode tested = this.path.path(node);
        if (tested.isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        if (!EQUIVALENCE.equivalent(tested, this.value)) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.valueTestFailure"));
        }
        return node.deepCopy();
    }
}

