/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.runtime;

import io.netty.channel.DefaultChannelId;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.quarkus.runtime.annotations.Recorder;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class NettyRecorder {
    private static final Logger log = Logger.getLogger(NettyRecorder.class);

    public void eagerlyInitChannelId() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                DefaultChannelId.newInstance();
                if (System.currentTimeMillis() - start > 1000L) {
                    log.warn("Localhost lookup took more than one second, you need to add a /etc/hosts entry to improve Quarkus startup time. On Windows the path is C:\\Windows\\System32\\Drivers\\etc\\hosts. See https://thoeni.io/post/macos-sierra-java/ for macOS details.");
                }
            }
        }).start();
    }

    public Supplier<Object> createEventLoop(final int nThreads) {
        return new Supplier<Object>(){
            volatile EventLoopGroup val;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EventLoopGroup get() {
                if (this.val == null) {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.val == null) {
                            this.val = new NioEventLoopGroup(nThreads);
                        }
                    }
                }
                return this.val;
            }
        };
    }
}

