/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.filters;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.runtime.shutdown.ShutdownListener;
import io.quarkus.vertx.http.runtime.filters.QuarkusRequestWrapper;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;

public class GracefulShutdownFilter
implements ShutdownListener,
Handler<HttpServerRequest> {
    private static Logger log = Logger.getLogger(GracefulShutdownFilter.class);
    private volatile Handler<HttpServerRequest> next;
    private volatile boolean running = true;
    private final AtomicInteger currentRequestCount = new AtomicInteger();
    private final AtomicReference<ShutdownListener.ShutdownNotification> notification = new AtomicReference();
    private final Handler<Void> requestDoneHandler = new Handler<Void>(){

        @Override
        public void handle(Void event) {
            ShutdownListener.ShutdownNotification n;
            int count = GracefulShutdownFilter.this.currentRequestCount.decrementAndGet();
            if (!GracefulShutdownFilter.this.running && count == 0 && (n = (ShutdownListener.ShutdownNotification)GracefulShutdownFilter.this.notification.get()) != null && GracefulShutdownFilter.this.notification.compareAndSet(n, null)) {
                n.done();
                log.info("All HTTP requests complete");
            }
        }
    };

    @Override
    public void handle(HttpServerRequest event) {
        if (!this.running) {
            event.response().setStatusCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).end();
            return;
        }
        this.currentRequestCount.incrementAndGet();
        ((QuarkusRequestWrapper)event).addRequestDoneHandler(this.requestDoneHandler);
        this.next.handle(event);
    }

    @Override
    public void shutdown(ShutdownListener.ShutdownNotification notification) {
        this.notification.set(notification);
        this.running = false;
        if (this.currentRequestCount.get() == 0) {
            if (this.notification.compareAndSet(notification, null)) {
                notification.done();
            }
        } else {
            log.info("Waiting for HTTP requests to complete");
        }
    }

    public void next(Handler<HttpServerRequest> next) {
        this.next = next;
    }
}

