/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.smallrye.mutiny.Uni;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;

public class QuarkusHttpUser
implements User {
    public static final String DEFERRED_IDENTITY_KEY = "io.quarkus.vertx.http.deferred-identity";
    public static final String AUTH_FAILURE_HANDLER = "io.quarkus.vertx.http.auth-failure-handler";
    private final SecurityIdentity securityIdentity;

    public QuarkusHttpUser(SecurityIdentity securityIdentity) {
        this.securityIdentity = securityIdentity;
    }

    @Override
    public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(this.securityIdentity.hasRole(authority)));
        return this;
    }

    @Override
    public User isAuthorised(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        resultHandler.handle(Future.succeededFuture(this.securityIdentity.hasRole(authority)));
        return this;
    }

    @Override
    public User clearCache() {
        return this;
    }

    @Override
    public JsonObject principal() {
        JsonObject ret = new JsonObject();
        ret.put("username", this.securityIdentity.getPrincipal().getName());
        return ret;
    }

    @Override
    public void setAuthProvider(AuthProvider authProvider) {
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public static SecurityIdentity getSecurityIdentityBlocking(RoutingContext routingContext, IdentityProviderManager identityProviderManager) {
        QuarkusHttpUser existing = (QuarkusHttpUser)routingContext.user();
        if (existing != null) {
            return existing.getSecurityIdentity();
        }
        Uni deferred = (Uni)routingContext.get(DEFERRED_IDENTITY_KEY);
        if (deferred != null) {
            return (SecurityIdentity)deferred.await().indefinitely();
        }
        if (identityProviderManager != null) {
            return identityProviderManager.authenticate(AnonymousAuthenticationRequest.INSTANCE).await().indefinitely();
        }
        return null;
    }

    public static Uni<SecurityIdentity> getSecurityIdentity(RoutingContext routingContext, IdentityProviderManager identityProviderManager) {
        QuarkusHttpUser existing = (QuarkusHttpUser)routingContext.user();
        if (existing != null) {
            return Uni.createFrom().item(existing.getSecurityIdentity());
        }
        Uni deferred = (Uni)routingContext.get(DEFERRED_IDENTITY_KEY);
        if (deferred != null) {
            return deferred;
        }
        if (identityProviderManager != null) {
            return identityProviderManager.authenticate(AnonymousAuthenticationRequest.INSTANCE);
        }
        return Uni.createFrom().nullItem();
    }
}

