/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import java.security.AccessController;
import org.jboss.logging.Logger;

class SecuritySupport {
    private static final Logger LOG = Logger.getLogger("io.smallrye.config");

    private SecuritySupport() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader tccl = null;
            try {
                tccl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                LOG.warn((Object)"Unable to get context classloader instance.", ex);
            }
            return tccl;
        });
    }
}

