/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.AsyncResolveConnectHelper;
import io.vertx.core.net.impl.HandlerHolder;
import io.vertx.core.net.impl.HandlerManager;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.core.net.impl.VertxEventLoopGroup;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.streams.ReadStream;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class NetServerImpl
implements Closeable,
MetricsProvider,
NetServer {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    protected final VertxInternal vertx;
    protected final NetServerOptions options;
    protected final ContextInternal creatingContext;
    protected final SSLHelper sslHelper;
    protected final boolean logEnabled;
    private final Map<Channel, NetSocketImpl> socketMap = new ConcurrentHashMap<Channel, NetSocketImpl>();
    private final VertxEventLoopGroup availableWorkers = new VertxEventLoopGroup();
    private final HandlerManager<Handlers> handlerManager = new HandlerManager(this.availableWorkers);
    private final NetSocketStream connectStream = new NetSocketStream();
    private ChannelGroup serverChannelGroup;
    private long demand = Long.MAX_VALUE;
    private volatile boolean listening;
    private Handler<NetSocket> registeredHandler;
    private volatile ServerID id;
    private NetServerImpl actualServer;
    private io.netty.util.concurrent.Future<Channel> bindFuture;
    private volatile int actualPort;
    private ContextInternal listenContext;
    private TCPMetrics metrics;
    private Handler<NetSocket> handler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;

    public NetServerImpl(VertxInternal vertx, NetServerOptions options) {
        this.vertx = vertx;
        this.options = new NetServerOptions(options);
        this.sslHelper = new SSLHelper(options, options.getKeyCertOptions(), options.getTrustOptions());
        this.creatingContext = vertx.getContext();
        this.logEnabled = options.getLogActivity();
        if (this.creatingContext != null) {
            if (this.creatingContext.isMultiThreadedWorkerContext()) {
                throw new IllegalStateException("Cannot use NetServer in a multi-threaded worker verticle");
            }
            this.creatingContext.addCloseHook(this);
        }
    }

    private synchronized void pauseAccepting() {
        this.demand = 0L;
    }

    private synchronized void resumeAccepting() {
        this.demand = Long.MAX_VALUE;
    }

    private synchronized void fetchAccepting(long amount) {
        if (amount > 0L) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
        }
    }

    protected synchronized boolean accept() {
        boolean accept;
        boolean bl = accept = this.demand > 0L;
        if (accept && this.demand != Long.MAX_VALUE) {
            --this.demand;
        }
        return accept;
    }

    protected boolean isListening() {
        return this.listening;
    }

    @Override
    public synchronized Handler<NetSocket> connectHandler() {
        return this.handler;
    }

    @Override
    public synchronized NetServer connectHandler(Handler<NetSocket> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set connectHandler when server is listening");
        }
        this.handler = handler;
        return this;
    }

    @Override
    public synchronized NetServer exceptionHandler(Handler<Throwable> handler) {
        if (this.isListening()) {
            throw new IllegalStateException("Cannot set exceptionHandler when server is listening");
        }
        this.exceptionHandler = handler;
        return this;
    }

    protected void initChannel(ChannelPipeline pipeline) {
        if (this.logEnabled) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        if (this.sslHelper.isSSL()) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0L, 0L, this.options.getIdleTimeout(), this.options.getIdleTimeoutUnit()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void listen(Handler<NetSocket> handler, SocketAddress socketAddress, Handler<AsyncResult<Void>> listenHandler) {
        Map<ServerID, NetServerImpl> sharedNetServers;
        if (handler == null) {
            throw new IllegalStateException("Set connect handler first");
        }
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listening = true;
        this.listenContext = this.vertx.getOrCreateContext();
        this.registeredHandler = handler;
        Map<ServerID, NetServerImpl> map = sharedNetServers = this.vertx.sharedNetServers();
        synchronized (map) {
            this.actualPort = socketAddress.port();
            String hostOrPath = socketAddress.host() != null ? socketAddress.host() : socketAddress.path();
            this.id = new ServerID(this.actualPort, hostOrPath);
            NetServerImpl shared = sharedNetServers.get(this.id);
            if (shared == null || this.actualPort == 0) {
                this.serverChannelGroup = new DefaultChannelGroup("vertx-acceptor-channels", GlobalEventExecutor.INSTANCE);
                ServerBootstrap bootstrap = new ServerBootstrap();
                bootstrap.group(this.availableWorkers);
                this.sslHelper.validate(this.vertx);
                bootstrap.childHandler(new ChannelInitializer<Channel>(){

                    @Override
                    protected void initChannel(Channel ch) {
                        if (!NetServerImpl.this.accept()) {
                            ch.close();
                            return;
                        }
                        HandlerHolder handler = NetServerImpl.this.handlerManager.chooseHandler(ch.eventLoop());
                        if (handler != null) {
                            if (NetServerImpl.this.sslHelper.isSSL()) {
                                ch.pipeline().addFirst("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler(ar -> {
                                    if (ar.succeeded()) {
                                        NetServerImpl.this.connected(handler, ch);
                                    } else {
                                        Handler<Throwable> exceptionHandler = ((Handlers)handler.handler).exceptionHandler;
                                        if (exceptionHandler != null) {
                                            handler.context.executeFromIO(v -> exceptionHandler.handle(ar.cause()));
                                        } else {
                                            log.error("Client from origin " + ch.remoteAddress() + " failed to connect over ssl: " + ar.cause());
                                        }
                                    }
                                }));
                                if (NetServerImpl.this.options.isSni()) {
                                    SniHandler sniHandler = new SniHandler(NetServerImpl.this.sslHelper.serverNameMapper(NetServerImpl.this.vertx));
                                    ch.pipeline().addFirst("ssl", (ChannelHandler)sniHandler);
                                } else {
                                    SslHandler sslHandler = new SslHandler(NetServerImpl.this.sslHelper.createEngine(NetServerImpl.this.vertx));
                                    sslHandler.setHandshakeTimeout(NetServerImpl.this.sslHelper.getSslHandshakeTimeout(), NetServerImpl.this.sslHelper.getSslHandshakeTimeoutUnit());
                                    ch.pipeline().addFirst("ssl", (ChannelHandler)sslHandler);
                                }
                            } else {
                                NetServerImpl.this.connected(handler, ch);
                            }
                        }
                    }
                });
                this.applyConnectionOptions(socketAddress.path() != null, bootstrap);
                this.handlerManager.addHandler(new Handlers(this, handler, this.exceptionHandler), this.listenContext);
                try {
                    this.bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, socketAddress, bootstrap);
                    this.bindFuture.addListener(res -> {
                        if (res.isSuccess()) {
                            Channel ch = (Channel)res.getNow();
                            log.trace("Net server listening on " + hostOrPath + ":" + ch.localAddress());
                            if (this.actualPort != -1) {
                                this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                            }
                            this.id = new ServerID(this.actualPort, this.id.host);
                            this.serverChannelGroup.add(ch);
                            Map map = sharedNetServers;
                            synchronized (map) {
                                sharedNetServers.put(this.id, this);
                            }
                            VertxMetrics metrics = this.vertx.metricsSPI();
                            if (metrics != null) {
                                this.metrics = metrics.createNetServerMetrics(this.options, new SocketAddressImpl(this.id.port, this.id.host));
                            }
                        } else {
                            Map map = sharedNetServers;
                            synchronized (map) {
                                sharedNetServers.remove(this.id);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    if (listenHandler != null) {
                        this.vertx.runOnContext(v -> listenHandler.handle(Future.failedFuture(t)));
                    } else {
                        log.error(t);
                    }
                    this.listening = false;
                    return;
                }
                if (this.actualPort != 0) {
                    sharedNetServers.put(this.id, this);
                }
                this.actualServer = this;
            } else {
                this.actualServer = shared;
                this.actualPort = shared.actualPort();
                VertxMetrics metrics = this.vertx.metricsSPI();
                this.metrics = metrics != null ? metrics.createNetServerMetrics(this.options, new SocketAddressImpl(this.id.port, this.id.host)) : null;
                this.actualServer.handlerManager.addHandler(new Handlers(this, handler, this.exceptionHandler), this.listenContext);
            }
            this.actualServer.bindFuture.addListener(res -> {
                if (listenHandler != null) {
                    Future ares;
                    if (res.isSuccess()) {
                        ares = Future.succeededFuture();
                    } else {
                        this.listening = false;
                        ares = Future.failedFuture(res.cause());
                    }
                    this.listenContext.runOnContext(v -> listenHandler.handle(ares));
                } else if (!res.isSuccess()) {
                    log.error((Object)"Failed to listen", res.cause());
                    this.listening = false;
                }
            });
        }
    }

    @Override
    public synchronized void close() {
        this.close(null);
    }

    @Override
    public NetServer listen(int port, String host) {
        return this.listen(port, host, null);
    }

    @Override
    public NetServer listen(int port) {
        return this.listen(port, "0.0.0.0", null);
    }

    @Override
    public NetServer listen(int port, Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(port, "0.0.0.0", listenHandler);
    }

    @Override
    public NetServer listen(SocketAddress localAddress) {
        return this.listen(localAddress, null);
    }

    @Override
    public synchronized NetServer listen(SocketAddress localAddress, Handler<AsyncResult<NetServer>> listenHandler) {
        this.listen(this.handler, localAddress, (AsyncResult<Void> ar) -> {
            if (listenHandler != null) {
                listenHandler.handle(ar.map(this));
            }
        });
        return this;
    }

    @Override
    public NetServer listen() {
        this.listen((Handler<AsyncResult<NetServer>>)null);
        return this;
    }

    @Override
    public NetServer listen(int port, String host, Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(SocketAddress.inetSocketAddress(port, host), listenHandler);
    }

    @Override
    public synchronized NetServer listen(Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(this.options.getPort(), this.options.getHost(), listenHandler);
    }

    @Override
    public ReadStream<NetSocket> connectStream() {
        return this.connectStream;
    }

    public void closeAll(Handler<AsyncResult<Void>> handler) {
        List<Handlers> list = this.handlerManager.handlers();
        List<Future> futures = list.stream().map(handlers -> Future.future(handlers.server::close)).collect(Collectors.toList());
        CompositeFuture fut = CompositeFuture.all(futures);
        fut.setHandler(ar -> handler.handle(ar.mapEmpty()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        Handler<AsyncResult<Void>> done;
        if (this.creatingContext != null) {
            this.creatingContext.removeCloseHook(this);
        }
        if (this.endHandler != null) {
            Handler<Void> handler = this.endHandler;
            this.endHandler = null;
            done = event -> {
                if (event.succeeded()) {
                    handler.handle((Void)event.result());
                }
                if (completionHandler != null) {
                    completionHandler.handle((AsyncResult<Void>)event);
                }
            };
        } else {
            done = completionHandler;
        }
        ContextInternal context = this.vertx.getOrCreateContext();
        if (!this.listening) {
            if (done != null) {
                this.executeCloseDone(context, done, null);
            }
            return;
        }
        this.listening = false;
        Map<ServerID, NetServerImpl> map = this.vertx.sharedNetServers();
        synchronized (map) {
            if (this.actualServer != null) {
                this.actualServer.handlerManager.removeHandler(new Handlers(this, this.registeredHandler, this.exceptionHandler), this.listenContext);
                if (this.actualServer.handlerManager.hasHandlers()) {
                    if (done != null) {
                        this.executeCloseDone(context, done, null);
                    }
                } else {
                    this.actualServer.actualClose(context, done);
                }
            } else {
                context.runOnContext(v -> done.handle(Future.succeededFuture()));
            }
        }
    }

    public synchronized boolean isClosed() {
        return !this.listening;
    }

    @Override
    public int actualPort() {
        return this.actualPort;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    private void actualClose(ContextInternal closeContext, Handler<AsyncResult<Void>> done) {
        if (this.id != null) {
            this.vertx.sharedNetServers().remove(this.id);
        }
        ContextInternal currCon = this.vertx.getContext();
        for (NetSocketImpl sock : this.socketMap.values()) {
            sock.close();
        }
        if (this.vertx.getContext() != currCon) {
            throw new IllegalStateException("Context was changed");
        }
        ChannelGroupFuture fut = this.serverChannelGroup.close();
        fut.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)cg -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
            this.executeCloseDone(closeContext, done, fut.cause());
        }));
    }

    private void connected(HandlerHolder<Handlers> handler, Channel ch) {
        this.initChannel(ch.pipeline());
        VertxHandler<NetSocketImpl> nh = VertxHandler.create(handler.context, ctx -> new NetSocketImpl(this.vertx, (ChannelHandlerContext)ctx, handler.context, this.sslHelper, this.metrics));
        nh.addHandler(conn -> {
            this.socketMap.put(ch, (NetSocketImpl)conn);
            handler.context.executeFromIO(v -> {
                if (this.metrics != null) {
                    conn.metric(this.metrics.connected(conn.remoteAddress(), conn.remoteName()));
                }
                conn.registerEventBusHandler();
                ((Handlers)handler.handler).connectionHandler.handle((NetSocket)conn);
            });
        });
        nh.removeHandler(conn -> this.socketMap.remove(ch));
        ch.pipeline().addLast("handler", nh);
    }

    private void executeCloseDone(ContextInternal closeContext, Handler<AsyncResult<Void>> done, Exception e) {
        if (done != null) {
            Future fut = e == null ? Future.succeededFuture() : Future.failedFuture(e);
            closeContext.runOnContext(v -> done.handle(fut));
        }
    }

    private void applyConnectionOptions(boolean domainSocket, ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static class Handlers {
        final NetServer server;
        final Handler<NetSocket> connectionHandler;
        final Handler<Throwable> exceptionHandler;

        public Handlers(NetServer server, Handler<NetSocket> connectionHandler, Handler<Throwable> exceptionHandler) {
            this.server = server;
            this.connectionHandler = connectionHandler;
            this.exceptionHandler = exceptionHandler;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Handlers that = (Handlers)o;
            if (!Objects.equals(this.connectionHandler, that.connectionHandler)) {
                return false;
            }
            return Objects.equals(this.exceptionHandler, that.exceptionHandler);
        }

        public int hashCode() {
            int result = 0;
            if (this.connectionHandler != null) {
                result = 31 * result + this.connectionHandler.hashCode();
            }
            if (this.exceptionHandler != null) {
                result = 31 * result + this.exceptionHandler.hashCode();
            }
            return result;
        }
    }

    private class NetSocketStream
    implements ReadStream<NetSocket> {
        private NetSocketStream() {
        }

        public NetSocketStream handler(Handler<NetSocket> handler) {
            NetServerImpl.this.connectHandler(handler);
            return this;
        }

        public NetSocketStream pause() {
            NetServerImpl.this.pauseAccepting();
            return this;
        }

        public NetSocketStream resume() {
            NetServerImpl.this.resumeAccepting();
            return this;
        }

        @Override
        public ReadStream<NetSocket> fetch(long amount) {
            NetServerImpl.this.fetchAccepting(amount);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NetSocketStream endHandler(Handler<Void> handler) {
            NetServerImpl netServerImpl = NetServerImpl.this;
            synchronized (netServerImpl) {
                NetServerImpl.this.endHandler = handler;
                return this;
            }
        }

        @Override
        public NetSocketStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    }
}

