/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;

public class UserHolder
implements ClusterSerializable {
    public RoutingContext context;
    public User user;

    public UserHolder() {
    }

    public UserHolder(RoutingContext context) {
        this.context = context;
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        User user;
        User user2 = user = this.context != null ? this.context.user() : this.user;
        if (user instanceof ClusterSerializable) {
            buffer.appendByte((byte)1);
            String className = user.getClass().getName();
            if (className == null) {
                throw new IllegalStateException("Cannot serialize " + user.getClass().getName());
            }
            byte[] bytes = className.getBytes(StandardCharsets.UTF_8);
            buffer.appendInt(bytes.length);
            buffer.appendBytes(bytes);
            ClusterSerializable cs = (ClusterSerializable)((Object)user);
            cs.writeToBuffer(buffer);
        } else {
            buffer.appendByte((byte)0);
        }
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        byte b;
        if ((b = buffer.getByte(pos++)) == 1) {
            int len = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + len);
            pos += len;
            String className = new String(bytes, StandardCharsets.UTF_8);
            try {
                Class<?> clazz = Utils.getClassLoader().loadClass(className);
                if (!ClusterSerializable.class.isAssignableFrom(clazz)) {
                    throw new ClassCastException(className + " is not ClusterSerializable");
                }
                ClusterSerializable obj = (ClusterSerializable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                pos = obj.readFromBuffer(pos, buffer);
                this.user = (User)((Object)obj);
            }
            catch (Exception e) {
                throw new VertxException(e);
            }
        } else {
            this.user = null;
        }
        return pos;
    }
}

