/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.PermittedOptions;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class BridgeOptions {
    public static final int DEFAULT_MAX_ADDRESS_LENGTH = 200;
    public static final int DEFAULT_MAX_HANDLERS_PER_SOCKET = 1000;
    public static final long DEFAULT_PING_TIMEOUT = 10000L;
    public static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    private int maxAddressLength;
    private int maxHandlersPerSocket;
    private long pingTimeout;
    private long replyTimeout;
    private List<PermittedOptions> inboundPermitted = new ArrayList<PermittedOptions>();
    private List<PermittedOptions> outboundPermitted = new ArrayList<PermittedOptions>();

    public BridgeOptions(BridgeOptions other) {
        this.maxAddressLength = other.maxAddressLength;
        this.maxHandlersPerSocket = other.maxHandlersPerSocket;
        this.pingTimeout = other.pingTimeout;
        this.replyTimeout = other.replyTimeout;
        this.inboundPermitted = new ArrayList<PermittedOptions>(other.inboundPermitted);
        this.outboundPermitted = new ArrayList<PermittedOptions>(other.outboundPermitted);
    }

    public BridgeOptions() {
        this.maxAddressLength = 200;
        this.maxHandlersPerSocket = 1000;
        this.pingTimeout = 10000L;
        this.replyTimeout = 30000L;
    }

    public BridgeOptions(JsonObject json) {
        JsonObject jobj;
        this.maxAddressLength = json.getInteger("maxAddressLength", 200);
        this.maxHandlersPerSocket = json.getInteger("maxHandlersPerSocket", 1000);
        this.pingTimeout = json.getLong("pingTimeout", 10000L);
        this.replyTimeout = json.getLong("replyTimeout", 30000L);
        JsonArray arr = json.getJsonArray("inboundPermitteds");
        if (arr != null) {
            for (Object obj : arr) {
                if (obj instanceof JsonObject) {
                    jobj = (JsonObject)obj;
                    this.inboundPermitted.add(new PermittedOptions(jobj));
                    continue;
                }
                throw new IllegalArgumentException("Invalid type " + obj.getClass() + " in inboundPermitteds array");
            }
        }
        if ((arr = json.getJsonArray("outboundPermitteds")) != null) {
            for (Object obj : arr) {
                if (obj instanceof JsonObject) {
                    jobj = (JsonObject)obj;
                    this.outboundPermitted.add(new PermittedOptions(jobj));
                    continue;
                }
                throw new IllegalArgumentException("Invalid type " + obj.getClass() + " in outboundPermitteds array");
            }
        }
    }

    public int getMaxAddressLength() {
        return this.maxAddressLength;
    }

    public BridgeOptions setMaxAddressLength(int maxAddressLength) {
        if (maxAddressLength < 1) {
            throw new IllegalArgumentException("maxAddressLength must be > 0");
        }
        this.maxAddressLength = maxAddressLength;
        return this;
    }

    public int getMaxHandlersPerSocket() {
        return this.maxHandlersPerSocket;
    }

    public BridgeOptions setMaxHandlersPerSocket(int maxHandlersPerSocket) {
        if (maxHandlersPerSocket < 1) {
            throw new IllegalArgumentException("maxHandlersPerSocket must be > 0");
        }
        this.maxHandlersPerSocket = maxHandlersPerSocket;
        return this;
    }

    public long getPingTimeout() {
        return this.pingTimeout;
    }

    public BridgeOptions setPingTimeout(long pingTimeout) {
        if (pingTimeout < 1L) {
            throw new IllegalArgumentException("pingTimeout must be > 0");
        }
        this.pingTimeout = pingTimeout;
        return this;
    }

    public long getReplyTimeout() {
        return this.replyTimeout;
    }

    public BridgeOptions setReplyTimeout(long replyTimeout) {
        if (replyTimeout < 1L) {
            throw new IllegalArgumentException("replyTimeout must be > 0");
        }
        this.replyTimeout = replyTimeout;
        return this;
    }

    public BridgeOptions addInboundPermitted(PermittedOptions permitted) {
        this.inboundPermitted.add(permitted);
        return this;
    }

    public List<PermittedOptions> getInboundPermitteds() {
        return this.inboundPermitted;
    }

    public void setInboundPermitted(List<PermittedOptions> inboundPermitted) {
        this.inboundPermitted = inboundPermitted;
    }

    public BridgeOptions addOutboundPermitted(PermittedOptions permitted) {
        this.outboundPermitted.add(permitted);
        return this;
    }

    public List<PermittedOptions> getOutboundPermitteds() {
        return this.outboundPermitted;
    }

    public void setOutboundPermitted(List<PermittedOptions> outboundPermitted) {
        this.outboundPermitted = outboundPermitted;
    }
}

