/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.spi.AsyncWriterInterceptor;
import org.jboss.resteasy.spi.AsyncWriterInterceptorContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.AcceptParser;

@ConstrainedTo(value=RuntimeType.SERVER)
@Priority(value=3000)
public class ServerContentEncodingAnnotationFilter
implements AsyncWriterInterceptor {
    @Context
    protected HttpRequest request;
    Set<String> encodings;

    public ServerContentEncodingAnnotationFilter(Set<String> encodings) {
        this.encodings = encodings;
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        this.setHeader(context.getHeaders());
        context.proceed();
    }

    private void setHeader(MultivaluedMap<String, Object> headers) {
        List acceptEncoding = (List)this.request.getHttpHeaders().getRequestHeaders().get("Accept-Encoding");
        if (acceptEncoding != null) {
            StringBuffer buf = new StringBuffer();
            for (String accept : acceptEncoding) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(accept);
            }
            List<String> accepts = AcceptParser.parseAcceptHeader(buf.toString());
            for (String encoding : accepts) {
                if (!this.encodings.contains(encoding.toLowerCase())) continue;
                headers.putSingle("Content-Encoding", encoding);
                break;
            }
        }
    }

    @Override
    public CompletionStage<Void> asyncAroundWriteTo(AsyncWriterInterceptorContext context) {
        this.setHeader(context.getHeaders());
        return context.asyncProceed();
    }
}

