/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class CompletableHelper {
    public static Completable toCompletable(Consumer<Handler<AsyncResult<Void>>> handler) {
        return AsyncResultCompletable.toCompletable(handler);
    }

    public static <T> CompletableObserver toObserver(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean completed = new AtomicBoolean();
        return new CompletableObserver(){

            @Override
            public void onSubscribe(@NonNull Disposable d) {
            }

            @Override
            public void onComplete() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle(Future.succeededFuture());
                }
            }

            public void onSuccess() {
                if (completed.compareAndSet(false, true)) {
                    handler.handle(Future.succeededFuture());
                }
            }

            @Override
            public void onError(Throwable error) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle(Future.failedFuture(error));
                }
            }
        };
    }
}

