/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.auth.oauth2;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.ext.auth.oauth2.OAuth2Response;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken
extends User {
    public static final TypeArg<AccessToken> __TYPE_ARG = new TypeArg<AccessToken>(obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken)obj), AccessToken::getDelegate);
    private final io.vertx.ext.auth.oauth2.AccessToken delegate;
    private JsonObject cached_0;
    private JsonObject cached_1;
    private JsonObject cached_2;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
        super((io.vertx.ext.auth.User)delegate);
        this.delegate = delegate;
    }

    public AccessToken(Object delegate) {
        super((io.vertx.ext.auth.User)((io.vertx.ext.auth.oauth2.AccessToken)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.AccessToken)delegate;
    }

    public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
        return this.delegate;
    }

    public boolean expired() {
        boolean ret = this.delegate.expired();
        return ret;
    }

    public JsonObject accessToken() {
        JsonObject ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.accessToken();
        return ret;
    }

    @Deprecated
    public JsonObject refreshToken() {
        JsonObject ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.refreshToken();
        return ret;
    }

    public JsonObject idToken() {
        JsonObject ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = this.delegate.idToken();
        return ret;
    }

    public String opaqueAccessToken() {
        String ret = this.delegate.opaqueAccessToken();
        return ret;
    }

    public String opaqueRefreshToken() {
        String ret = this.delegate.opaqueRefreshToken();
        return ret;
    }

    public String opaqueIdToken() {
        String ret = this.delegate.opaqueIdToken();
        return ret;
    }

    public String tokenType() {
        String ret = this.delegate.tokenType();
        return ret;
    }

    public AccessToken setTrustJWT(boolean trust) {
        this.delegate.setTrustJWT(trust);
        return this;
    }

    public AccessToken refresh(Handler<AsyncResult<Void>> callback) {
        this.delegate.refresh(callback);
        return this;
    }

    public Completable rxRefresh() {
        return AsyncResultCompletable.toCompletable(handler -> this.refresh((Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken revoke(String token_type, Handler<AsyncResult<Void>> callback) {
        this.delegate.revoke(token_type, callback);
        return this;
    }

    public Completable rxRevoke(String token_type) {
        return AsyncResultCompletable.toCompletable(handler -> this.revoke(token_type, (Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken logout(Handler<AsyncResult<Void>> callback) {
        this.delegate.logout(callback);
        return this;
    }

    public Completable rxLogout() {
        return AsyncResultCompletable.toCompletable(handler -> this.logout((Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken introspect(Handler<AsyncResult<Void>> callback) {
        this.delegate.introspect(callback);
        return this;
    }

    public Completable rxIntrospect() {
        return AsyncResultCompletable.toCompletable(handler -> this.introspect((Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> callback) {
        this.delegate.introspect(tokenType, callback);
        return this;
    }

    public Completable rxIntrospect(String tokenType) {
        return AsyncResultCompletable.toCompletable(handler -> this.introspect(tokenType, (Handler<AsyncResult<Void>>)handler));
    }

    public AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) {
        this.delegate.userInfo(callback);
        return this;
    }

    public Single<JsonObject> rxUserInfo() {
        return AsyncResultSingle.toSingle(handler -> this.userInfo((Handler<AsyncResult<JsonObject>>)handler));
    }

    public AccessToken fetch(String resource, final Handler<AsyncResult<OAuth2Response>> callback) {
        this.delegate.fetch(resource, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle(Future.succeededFuture(OAuth2Response.newInstance(ar.result())));
                } else {
                    callback.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<OAuth2Response> rxFetch(String resource) {
        return AsyncResultSingle.toSingle(handler -> this.fetch(resource, (Handler<AsyncResult<OAuth2Response>>)handler));
    }

    public AccessToken fetch(HttpMethod method, String resource, JsonObject headers, Buffer payload, final Handler<AsyncResult<OAuth2Response>> callback) {
        this.delegate.fetch(method, resource, headers, payload.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>(){

            @Override
            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
                if (ar.succeeded()) {
                    callback.handle(Future.succeededFuture(OAuth2Response.newInstance(ar.result())));
                } else {
                    callback.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<OAuth2Response> rxFetch(HttpMethod method, String resource, JsonObject headers, Buffer payload) {
        return AsyncResultSingle.toSingle(handler -> this.fetch(method, resource, headers, payload, (Handler<AsyncResult<OAuth2Response>>)handler));
    }

    public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
        return arg != null ? new AccessToken(arg) : null;
    }
}

