/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.launcher.QuarkusLauncher;
import io.quarkus.runtime.Application;
import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.QuarkusApplication;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.jboss.logmanager.LogManager;

public class Quarkus {
    public static void run(Class<? extends QuarkusApplication> quarkusApplication, String ... args) {
        Quarkus.run(quarkusApplication, null, args);
    }

    public static void run(Class<? extends QuarkusApplication> quarkusApplication, Consumer<Integer> exitHandler, String ... args) {
        try {
            System.setProperty("java.util.logging.manager", LogManager.class.getName());
            Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl", false, Thread.currentThread().getContextClassLoader());
            Application application = (Application)appClass.newInstance();
            ApplicationLifecycleManager.run(application, quarkusApplication, exitHandler, args);
            return;
        }
        catch (ClassNotFoundException appClass) {
        }
        catch (Exception e) {
            Logger.getLogger(Quarkus.class).error((Object)"Error running Quarkus", e);
            if (exitHandler != null) {
                exitHandler.accept(1);
            } else {
                ApplicationLifecycleManager.getDefaultExitCodeHandler().accept(1);
            }
            return;
        }
        Quarkus.launchFromIDE(quarkusApplication, exitHandler, args);
    }

    private static void launchFromIDE(Class<? extends QuarkusApplication> quarkusApplication, Consumer<Integer> exitHandler, String ... args) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int pos = 2;
        while (stackTrace[pos].getClassName().equals(Quarkus.class.getName())) {
            ++pos;
        }
        String callingClass = stackTrace[pos].getClassName();
        QuarkusLauncher.launch((String)callingClass, (String)(quarkusApplication == null ? null : quarkusApplication.getName()), exitHandler, (String[])args);
    }

    public static void run(String ... args) {
        Quarkus.run(null, args);
    }

    public static void asyncExit(int code) {
        ApplicationLifecycleManager.exit(code);
    }

    public static void asyncExit() {
        ApplicationLifecycleManager.exit(-1);
    }

    public static void waitForExit() {
        ApplicationLifecycleManager.waitForExit();
    }

    public static void blockingExit() {
        Application app = Application.currentApplication();
        Quarkus.asyncExit();
        if (app != null) {
            app.awaitShutdown();
        }
    }
}

