/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.overflow.MultiOnOverflowBufferOp;
import io.smallrye.mutiny.operators.multi.overflow.MultiOnOverflowDropItemsOp;
import io.smallrye.mutiny.operators.multi.overflow.MultiOnOverflowKeepLastOp;
import java.util.function.Consumer;

public class MultiOverflow<T> {
    private final Multi<T> upstream;

    public MultiOverflow(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> buffer() {
        return this.buffer(128);
    }

    public Multi<T> buffer(int size) {
        return Infrastructure.onMultiCreation(new MultiOnOverflowBufferOp<Object>(this.upstream, ParameterValidation.positive(size, "size"), false, x -> {}));
    }

    public Multi<T> drop() {
        return Infrastructure.onMultiCreation(new MultiOnOverflowDropItemsOp<T>(this.upstream));
    }

    public Multi<T> drop(Consumer<T> callback) {
        return Infrastructure.onMultiCreation(new MultiOnOverflowDropItemsOp<T>(this.upstream, ParameterValidation.nonNull(callback, "callback")));
    }

    public Multi<T> dropPreviousItems() {
        return Infrastructure.onMultiCreation(new MultiOnOverflowKeepLastOp<T>(this.upstream));
    }
}

