/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Subscription;

public class UniAndCombination<I, O>
extends UniOperator<I, O> {
    private static final Object SENTINEL = new Object();
    private final Function<List<?>, O> combinator;
    private final List<Uni<?>> unis = new ArrayList();
    private final boolean collectAllFailureBeforeFiring;

    public UniAndCombination(Uni<? extends I> upstream, List<? extends Uni<?>> others, Function<List<?>, O> combinator, boolean collectAllFailureBeforeFiring) {
        super(upstream);
        if (upstream != null) {
            this.unis.add(upstream);
        }
        this.unis.addAll(others);
        this.combinator = combinator;
        this.collectAllFailureBeforeFiring = collectAllFailureBeforeFiring;
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super O> subscriber) {
        AndSupervisor andSupervisor = new AndSupervisor(subscriber);
        subscriber.onSubscribe(andSupervisor);
        andSupervisor.run();
    }

    private class UniHandler
    implements UniSubscription,
    UniSubscriber {
        final AtomicReference<UniSubscription> subscription = new AtomicReference();
        private final AndSupervisor supervisor;
        private final Uni uni;
        Object item = UniAndCombination.access$300();
        Throwable failure;

        UniHandler(AndSupervisor supervisor, Uni observed) {
            this.supervisor = supervisor;
            this.uni = observed;
        }

        @Override
        public final void onSubscribe(UniSubscription sub) {
            if (!this.subscription.compareAndSet(null, sub)) {
                sub.cancel();
            }
        }

        @Override
        public final void onFailure(Throwable t) {
            if (this.subscription.getAndSet(EmptyUniSubscription.CANCELLED) == EmptyUniSubscription.CANCELLED) {
                Infrastructure.handleDroppedException(t);
                return;
            }
            this.failure = t;
            this.supervisor.check(this, true);
        }

        public final void onItem(Object x) {
            if (this.subscription.getAndSet(EmptyUniSubscription.CANCELLED) == EmptyUniSubscription.CANCELLED) {
                return;
            }
            this.item = x;
            this.supervisor.check(this, false);
        }

        @Override
        public void cancel() {
            Subscription sub = this.subscription.getAndSet(EmptyUniSubscription.CANCELLED);
            if (sub != null) {
                sub.cancel();
            }
        }

        public void subscribe() {
            AbstractUni.subscribe(this.uni, this);
        }
    }

    private class AndSupervisor
    implements UniSubscription {
        private final List<UniHandler> handlers = new ArrayList<UniHandler>();
        private final UniSerializedSubscriber<? super O> subscriber;
        AtomicBoolean cancelled = new AtomicBoolean();

        AndSupervisor(UniSerializedSubscriber<? super O> sub) {
            this.subscriber = sub;
            for (Uni u : UniAndCombination.this.unis) {
                UniHandler result = new UniHandler(this, u);
                this.handlers.add(result);
            }
        }

        private void run() {
            this.handlers.forEach(UniHandler::subscribe);
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                this.handlers.forEach(UniHandler::cancel);
            }
        }

        void check(UniHandler res, boolean failed) {
            int incomplete = UniAndCombination.this.unis.size();
            if (failed && !UniAndCombination.this.collectAllFailureBeforeFiring) {
                if (this.cancelled.compareAndSet(false, true)) {
                    this.handlers.forEach(UniHandler::cancel);
                    this.subscriber.onFailure(res.failure);
                }
                return;
            }
            for (UniHandler result : this.handlers) {
                if (result.failure == null && result.item == SENTINEL) continue;
                --incomplete;
            }
            if (incomplete == 0 && this.cancelled.compareAndSet(false, true)) {
                List<Throwable> failures = this.getFailures();
                List<Object> items = this.getItems();
                this.computeAndFireTheOutcome(failures, items);
            }
        }

        private void computeAndFireTheOutcome(List<Throwable> failures, List<Object> items) {
            if (failures.isEmpty()) {
                Object aggregated;
                try {
                    aggregated = UniAndCombination.this.combinator.apply(items);
                }
                catch (Throwable e) {
                    this.subscriber.onFailure(e);
                    return;
                }
                this.subscriber.onItem(aggregated);
            } else if (failures.size() == 1) {
                this.subscriber.onFailure(failures.get(0));
            } else {
                this.subscriber.onFailure(new CompositeException(failures));
            }
        }

        private List<Object> getItems() {
            return this.handlers.stream().map(u -> u.item).collect(Collectors.toList());
        }

        private List<Throwable> getFailures() {
            return this.handlers.stream().filter(u -> u.failure != null).map(u -> u.failure).collect(Collectors.toList());
        }
    }
}

