/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.smallrye.mutiny.Uni;
import java.security.Principal;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

@RequestScoped
public class SecurityIdentityAssociation
implements CurrentIdentityAssociation {
    private volatile SecurityIdentity identity;
    private volatile Uni<SecurityIdentity> deferredIdentity;
    @Inject
    IdentityProviderManager identityProviderManager;

    @Produces
    @RequestScoped
    Principal principal() {
        return new Principal(){

            @Override
            public String getName() {
                return SecurityIdentityAssociation.this.getIdentity().getPrincipal().getName();
            }
        };
    }

    @Override
    public void setIdentity(SecurityIdentity identity) {
        this.identity = identity;
        this.deferredIdentity = null;
    }

    @Override
    public void setIdentity(Uni<SecurityIdentity> identity) {
        this.identity = null;
        this.deferredIdentity = identity;
    }

    @Override
    public Uni<SecurityIdentity> getDeferredIdentity() {
        return this.deferredIdentity;
    }

    @Override
    public SecurityIdentity getIdentity() {
        if (this.identity == null) {
            if (this.deferredIdentity != null) {
                if (BlockingOperationControl.isBlockingAllowed()) {
                    this.identity = this.deferredIdentity.await().indefinitely();
                } else {
                    throw new RuntimeException("Cannot call getIdentity() from the IO thread when lazy authentication is in use, as resolving the identity may block the thread. Instead you should inject the CurrentIdentityAssociation, call CurrentIdentityAssociation#getDeferredIdentity() and subscribe to the Uni.");
                }
            }
            if (this.identity == null) {
                this.identity = this.identityProviderManager.authenticate(AnonymousAuthenticationRequest.INSTANCE).await().indefinitely();
            }
        }
        return this.identity;
    }
}

