/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AssertSubscriber<T>
implements Subscriber<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Subscription> subscription = new AtomicReference();
    private final AtomicLong requested = new AtomicLong();
    private final List<T> items = new CopyOnWriteArrayList<T>();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final AtomicBoolean completed = new AtomicBoolean();
    private final Subscriber<T> spy;
    private int numberOfSubscription = 0;
    private final boolean upfrontCancellation;
    private boolean cancelled;

    public AssertSubscriber(long requested, boolean cancelled) {
        this(null, requested, cancelled);
    }

    public AssertSubscriber(Subscriber<T> spy, long requested, boolean cancelled) {
        this.requested.set(requested);
        this.upfrontCancellation = cancelled;
        this.spy = spy;
    }

    public AssertSubscriber(Subscriber<T> spy) {
        this(spy, 0L, false);
    }

    public AssertSubscriber(long requested) {
        this(requested, false);
    }

    public static <T> AssertSubscriber<T> create() {
        return new AssertSubscriber<T>(0L);
    }

    public static <T> AssertSubscriber<T> create(long requested) {
        return new AssertSubscriber<T>(requested);
    }

    public static <T> AssertSubscriber<T> create(Subscriber<T> spy) {
        return new AssertSubscriber<T>(spy);
    }

    public AssertSubscriber<T> assertCompleted() {
        if (!this.completed.get()) {
            throw new AssertionError((Object)"The stream has not completed");
        }
        if (this.failure.get() != null) {
            throw new AssertionError("The stream has not completed because of a failure", this.failure.get());
        }
        return this;
    }

    public AssertSubscriber<T> assertFailedWith(Class<? extends Throwable> typeOfException, String message) {
        if (this.failure.get() == null) {
            throw new AssertionError((Object)"The multi didn't failed");
        }
        if (this.completed.get()) {
            throw new AssertionError((Object)"The multi completed successfully");
        }
        Throwable throwable = this.failure.get();
        if (!typeOfException.isInstance(this.failure.get())) {
            throw new AssertionError((Object)("Expected the failure to be of type " + typeOfException.getCanonicalName() + " but was " + this.failure.get().getClass().getCanonicalName()));
        }
        if (message != null && !throwable.getMessage().contains(message)) {
            throw new AssertionError((Object)("Expected the failure message to contain \"" + message + "\" but was: \"" + throwable.getMessage() + "\""));
        }
        return this;
    }

    public AssertSubscriber<T> assertHasNotReceivedAnyItem() {
        if (!this.items.isEmpty()) {
            throw new AssertionError((Object)"Items have been received");
        }
        return this;
    }

    public AssertSubscriber<T> assertSubscribed() {
        if (this.numberOfSubscription != 1) {
            throw new AssertionError((Object)("Expected to be subscribed (number of subscriptions was " + this.numberOfSubscription + ")"));
        }
        return this;
    }

    public AssertSubscriber<T> assertNotSubscribed() {
        if (this.numberOfSubscription != 0) {
            throw new AssertionError((Object)("Did not expect to be subscribed (number of subscriptions was " + this.numberOfSubscription + ")"));
        }
        return this;
    }

    public AssertSubscriber<T> assertTerminated() {
        if (this.latch.getCount() != 0L) {
            throw new AssertionError((Object)"Expected to be terminated");
        }
        return this;
    }

    public AssertSubscriber<T> assertNotTerminated() {
        if (this.latch.getCount() == 0L) {
            throw new AssertionError((Object)"Did not expect to be terminated");
        }
        return this;
    }

    @SafeVarargs
    public final AssertSubscriber<T> assertItems(T ... expected) {
        if (this.items.size() != expected.length) {
            throw new AssertionError((Object)("Expected to have received: " + Arrays.toString(expected) + " but has received: " + this.items));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (!expected[i].equals(this.items.get(i))) {
                throw new AssertionError((Object)("Expected to have received: " + Arrays.toString(expected) + " but has received: " + this.items));
            }
        }
        return this;
    }

    public AssertSubscriber<T> await() {
        if (this.latch.getCount() == 0L) {
            return this;
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public AssertSubscriber<T> await(Duration duration) {
        if (this.latch.getCount() == 0L) {
            return this;
        }
        try {
            if (!this.latch.await(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)"Not terminated before timeout");
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public AssertSubscriber<T> cancel() {
        if (this.subscription.get() == null) {
            throw new AssertionError((Object)"There is not subscription");
        }
        this.subscription.get().cancel();
        this.cancelled = true;
        return this;
    }

    public AssertSubscriber<T> request(long req) {
        this.requested.addAndGet(req);
        if (this.subscription.get() != null) {
            this.subscription.get().request(req);
        }
        return this;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.spy != null) {
            this.spy.onSubscribe(s);
        }
        ++this.numberOfSubscription;
        this.subscription.set(s);
        if (this.upfrontCancellation) {
            s.cancel();
            this.cancelled = true;
            return;
        }
        if (this.requested.get() > 0L) {
            s.request(this.requested.get());
        }
    }

    @Override
    public synchronized void onNext(T t) {
        if (this.spy != null) {
            this.spy.onNext(t);
        }
        this.items.add(t);
    }

    @Override
    public void onError(Throwable t) {
        if (this.spy != null) {
            this.spy.onError(t);
        }
        this.failure.set(t);
        this.latch.countDown();
    }

    @Override
    public void onComplete() {
        this.completed.set(true);
        if (this.spy != null) {
            this.spy.onComplete();
        }
        this.latch.countDown();
    }

    public List<T> getItems() {
        return this.items;
    }

    public Throwable getFailure() {
        return this.failure.get();
    }

    public AssertSubscriber<T> run(Runnable action) {
        try {
            action.run();
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean hasCompleted() {
        return this.completed.get();
    }
}

