/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.smallrye.mutiny.tuples.Functions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class UniOnTerminationCall<I>
extends UniOperator<I, I> {
    private final Functions.Function3<? super I, Throwable, Boolean, Uni<?>> mapper;

    public UniOnTerminationCall(Uni<I> upstream, Functions.Function3<? super I, Throwable, Boolean, Uni<?>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    @Override
    protected void subscribing(final UniSubscriber<? super I> subscriber) {
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<I, I>(subscriber){
            private volatile Cancellable cancellable;
            private final AtomicBoolean invoked;
            {
                super(subscriber2);
                this.invoked = new AtomicBoolean();
            }

            @Override
            public void onSubscribe(final UniSubscription subscription) {
                subscriber.onSubscribe(new UniSubscription(){

                    @Override
                    public void cancel() {
                        if (cancellable != null) {
                            cancellable.cancel();
                            subscription.cancel();
                        } else {
                            this.execute(null, null, true).subscribe().with(ignored -> subscription.cancel(), failure -> {
                                Infrastructure.handleDroppedException(failure);
                                subscription.cancel();
                            });
                        }
                    }
                });
            }

            private Uni<?> execute(I item, Throwable failure, Boolean cancelled) {
                if (this.invoked.compareAndSet(false, true)) {
                    try {
                        return (Uni)Objects.requireNonNull(UniOnTerminationCall.this.mapper.apply(item, failure, cancelled), "Uni should not be null");
                    }
                    catch (Throwable err) {
                        return Uni.createFrom().failure(err);
                    }
                }
                return Uni.createFrom().nullItem();
            }

            @Override
            public void onItem(I item) {
                this.cancellable = this.execute(item, null, false).subscribe().with(ignored -> subscriber.onItem(item), subscriber::onFailure);
            }

            @Override
            public void onFailure(Throwable failure) {
                this.cancellable = this.execute(null, failure, false).subscribe().with(ignored -> subscriber.onFailure(failure), ignored -> subscriber.onFailure(new CompositeException(failure, (Throwable)ignored)));
            }
        });
    }
}

